package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class ImageNode extends Node {
    public String label;
    public String url;
    public String title;
    
    public ImageNode(String label, String url, String title) {
        this.label = label;
        this.url = url;
        this.title = title;
    }
    
    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append("<img src=\"").append(HtmlEscape.escapeURL(url))
         .append("\" alt=\"");
        toPlainText(b);
        if(title.isEmpty())
            b.append("\" />");
        else {
            b.append("\" title=\"");
            b.append(HtmlEscape.escape(title));
            b.append("\" />");
        }
    }
}
