package org.simantics.scl.compiler.markdown.inlines;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import gnu.trove.map.hash.THashMap;

public class Entities {
    public static final THashMap<String, String> ENTITY_MAP = new THashMap<String, String>();
    public static int MAX_ENTITY_LENGTH;
    
    static {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(Entities.class.getResourceAsStream("entities.dat"), Charset.forName("UTF-8")));
            String line;
            MAX_ENTITY_LENGTH = 0;
            while((line = reader.readLine()) != null) {
                if(line.isEmpty())
                    continue;
                int p = line.indexOf(' ');
                String entity = line.substring(0, p);
                String character = line.substring(p+1);
                ENTITY_MAP.put(entity, character);
                MAX_ENTITY_LENGTH = Math.max(MAX_ENTITY_LENGTH, entity.length());
            }
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
}
