package org.simantics.scl.compiler.elaboration.query.pre;

import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.errors.Locations;

public class QPreEquals extends PreQuery {
    public Expression left;
    public Expression right;
    
    public QPreEquals(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Query resolve(TranslationContext context) {
        PreQuery oldPreQuery = context.currentPreQuery;
        context.currentPreQuery = this;
        QAtom atom = new QAtom(EqRelation.INSTANCE, 
                new Expression[] {
                left.resolve(context), 
                right.resolve(context)});
        context.currentPreQuery = oldPreQuery;
        atom.location = location;
        return withSideQueries(atom);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            left.setLocationDeep(loc);
            right.setLocationDeep(loc);
        }
    }
    
    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}
