package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.codegen.writer.ModuleWriter;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class EExternalConstant extends Expression {
    Object value;
    
    public EExternalConstant(Object value, Type type) {
        this.value = value;
        setType(type);
    }
    
    public Object getValue() {
        return value;
    }

    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(value);
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError("EExternalConstants must have explicitly defined type.");
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        ModuleWriter mw = w.getModuleWriter();
        return mw.getExternalConstant(value, getType());
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EExternalConstant(value, getType().replace(context.tvarMap));
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return this;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        return new IConstant(value);
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
