package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PreCommitOp extends PlanOp {
    public PreCommitOp(long location) {
        super(location);
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("PRE_COMMIT");
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        for(PartnerFact activeFact : planContext.partnerFacts) {
            if(activeFact.killAfterMatch)
                w.apply(location, activeFact.constraint.removeProcedure, planContext.getStoreVar(activeFact.constraint), activeFact.factVar);
        }
        planContext.nextOp(w);
    }

}
