package org.simantics.scl.compiler.common.names;

import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class Names {
    
    public static final Name ArrayList_add = Name.create("ArrayList", "add");
    public static final Name ArrayList_freeze = Name.create("ArrayList", "freeze");
    public static final Name ArrayList_new = Name.create("ArrayList", "new");
    public static final Name Builtin_equals = Name.create(Types.BUILTIN, "==");
    public static final Name Builtin_fail = Name.create(Types.BUILTIN, "fail");
    public static final Name Builtin_runProc = Name.create(Types.BUILTIN, "runProc");
    public static final Name Builtin_createCHRContext = Name.create(Types.BUILTIN, "createCHRContext");
    public static final Name Data_XML_createElement = Name.create("Data/XML", "createElement");
    public static final Type Data_XML_Element = Types.con("Data/XML", "Element");
    public static final TCon Expressions_Context_Context = Types.con("Expressions/Context", "Context");    
    public static final Name Expressions_Context_contextGet = Name.create("Expressions/Context", "contextGet");
    public static final Name JavaBuiltin_unsafeCoerce = Name.create("JavaBuiltin", "unsafeCoerce");
    public static final Name MList_add = Name.create("MList", "add");
    public static final Name MList_create = Name.create("MList", "create");
    public static final Name MList_freeze = Name.create("MList", "freeze");
    public static final Name MList_removeLast = Name.create("MList", "removeLast");
    public static final TCon MList_T = Types.con("MList", "T");
    public static final Name MSet_add = Name.create("MSet", "add");
    public static final Name MSet_contains = Name.create("MSet", "contains");
    public static final Name MSet_create = Name.create("MSet", "create");
    public static final Name MSet_iter = Name.create("MSet", "iter");
    public static final Name MSet_mapFirst = Name.create("MSet", "mapFirst");
    public static final TCon MSet_T = Types.con("MSet", "T");
    public static final Name Prelude_addList = Name.create("Prelude", "addList");
    public static final Name Prelude_any = Name.create("Prelude", "any");
    public static final Name Prelude_appendList = Name.create("Prelude", "appendList");
    public static final Name Prelude_bind = Name.create("Prelude", ">>=");
    public static final Name Prelude_bindE = Name.create("Prelude", "bindE");
    public static final Name Prelude_build = Name.create("Prelude", "build");
    public static final Name Prelude_concatMap = Name.create("Prelude", "concatMap");
    public static final Name Prelude_dollar = Name.create("Prelude", "$");
    public static final Name Prelude_elem = Name.create("Prelude", "elem");
    public static final Name Prelude_elemMaybe = Name.create("Prelude", "elemMaybe");
    public static final Name Prelude_emptyList = Name.create("Prelude", "emptyList");
    public static final Name Prelude_foldl = Name.create("Prelude", "foldl");
    public static final Name Prelude_fromDouble = Name.create("Prelude", "fromDouble");
    public static final Name Prelude_fromInteger = Name.create("Prelude", "fromInteger");
    public static final Name Prelude_guardList = Name.create("Prelude", "guardList");
    public static final Name Prelude_iterList = Name.create("Prelude", "iterList");
    public static final Name Prelude_mapFirst = Name.create("Prelude", "mapFirst");
    public static final Name Prelude_mapList = Name.create("Prelude", "mapList");
    public static final Name Prelude_neg = Name.create("Prelude", "neg");
    public static final Name Prelude_not = Name.create("Prelude", "not");
    public static final Name Prelude_range = Name.create("Prelude", "range");
    public static final Name Prelude_showForPrinting = Name.create("Prelude", "showForPrinting");
    public static final Name Prelude_singletonList = Name.create("Prelude", "singletonList");
    public static final Name R_R_runR = Name.create("R/R", "runR");
    public static final Name Random_runRandom = Name.create("Random", "runRandom");
    public static final Name Serialization_ioSize = Name.create("Serialization", "ioSize");
    public static final Name Serialization_read = Name.create("Serialization", "read");
    public static final Name Serialization_write = Name.create("Serialization", "write");
    public static final Name Simantics_DB_newResource = Name.create("Simantics/DB", "newResource");
    public static final Name Simantics_DB_syncRead = Name.create("Simantics/DB", "syncRead");
    public static final Name Simantics_DB_syncWrite = Name.create("Simantics/DB", "syncWrite");
    public static final Name Simantics_Variables_child_ = Name.create("Simantics/Variables", "child_");
    public static final Name Simantics_Variables_property = Name.create("Simantics/Variables", "property");
    public static final Name Simantics_Variables_untypedPropertyValue = Name.create("Simantics/Variables", "untypedPropertyValue");
    public static final Name Unifiable_createUMap = Name.create("Unification", "createUMap");
    public static final Name Unifiable_extractWithDefault = Name.create("Unification", "extractWithDefault");
    public static final Name Unifiable_getUMapWithDefault = Name.create("Unification", "getUMapWithDefault");
    public static final Name Unifiable_putUMap = Name.create("Unification", "putUMap");
    public static final Name Unifiable_putUMapC = Name.create("Unification", "putUMapC");
    public static final Name Unifiable_uCons = Name.create("Unification", "uCons");
    public static final Name Unifiable_uId = Name.create("Unification", "uId");
    public static final TCon Unifiable_UMap = Types.con("Unification", "UMap");
    public static final TCon Unifiable_Unifiable = Types.con("Unification", "Unifiable");
    public static final Name Unifiable_uPending = Name.create("Unification", "uPending");
    public static final Name Unifiable_uTag = Name.create("Unification", "uTag");
    public static final TCon Unifiable_UTag = Types.con("Unification", "UTag");
    public static final Name Unifiable_uVar = Name.create("Unification", "uVar");
    public static final Name Vector_anyVector = Name.create("Vector", "anyVector");
    public static final Name Vector_concatMapVector = Name.create("Vector", "concatMapVector");
    public static final Name Vector_iterVector = Name.create("Vector", "iterVector");
    public static final Name Vector_mapFirstVector = Name.create("Vector", "mapFirstVector");
    
}
