package org.simantics.ltk;

import java.io.IOException;
import java.io.InputStream;

public class SourcePart implements ISource {
	ISource originalSource;
	int startPos;
	int startLine;
	
	public SourcePart(ISource originalSource, int startPos, int startLine) {
		this.originalSource = originalSource;
		this.startPos = startPos;
		this.startLine = startLine;
	}

	@Override
	public String getName() {
		return originalSource.getName();
	}

	@Override
	public InputStream open() throws IOException {
		throw new UnsupportedOperationException();
	}

	@Override
	public int length() throws IOException {
		throw new UnsupportedOperationException();
	}

	@Override
	public int startPos() {
		return startPos;
	}

	@Override
	public int startLine() {
		return startLine;
	}

	public ISource getOriginalSource() {
		return originalSource;
	}
}
