package org.simantics.ltk;

import java.io.IOException;
import java.io.InputStream;

public class LocalResourceSource implements ISource {
    Class<?> clazz;
    String resource;
    
    public LocalResourceSource(Class<?> clazz, String resource) {
        this.clazz = clazz;
        this.resource = resource;
    }

    @Override
    public InputStream open() throws IOException {
        return clazz.getResourceAsStream(resource);
    }
    
    @Override
    public String getName() {
        return resource;
    }

    @Override
    public int length() throws IOException {
        return -1;
    }
    
    @Override
    public int startPos() {
        return 0;
    }
    
    @Override
    public int startLine() {
        return 0;
    }
}
