package org.simantics.ltk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSource implements ISource {
	File file;
	
	public FileSource(File file) {
		this.file = file;
	}

	public FileSource(String fileName) {
		this.file = new File(fileName);
	}

	@Override
	public InputStream open() throws IOException {
		return new FileInputStream(file);
	}
	
	@Override
	public String getName() {
		return file.getName();
	}

	@Override
	public int length() throws IOException {
		return (int)file.length();
	}
	
	@Override
	public int startPos() {
		return 0;
	}
	
	@Override
	public int startLine() {
		return 0;
	}
}
