/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogConfigurator.class);

    private LogConfigurator() {
    }

    public static void setLoggingLevel(String level) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting logger level to {}", (Object)level);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Level ll = LogConfigurator.getLoggerLevel(level);
        List loggerList = context.getLoggerList();
        loggerList.forEach(l -> l.setLevel(ll));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loggers installed {}", (Object)loggerList);
        }
    }

    public static void setLoggingLevelForLogger(String logger, String level) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Setting logger level to {} for loggers {}", (Object)level, (Object)logger);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Level ll = LogConfigurator.getLoggerLevel(level);
        ch.qos.logback.classic.Logger loggerList = context.getLogger(logger);
        loggerList.setLevel(ll);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loggers installed {}", (Object)loggerList);
        }
    }

    private static Level getLoggerLevel(String level) {
        return Level.valueOf((String)level);
    }
}

