/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging.ui.handlers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.logging.LogCollector;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveLogFilesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveLogFilesHandler.class);
    private static final String[] FILTER_NAMES = new String[]{"ZIP-archive", "AllFiles (*.*)"};
    private static final String[] FILTER_EXTENSIONS = new String[]{"*.zip", "*.*"};
    private static final String USER_HOME = System.getProperty("user.home");

    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTENSIONS);
        if (USER_HOME != null && Files.exists(Paths.get(USER_HOME, new String[0]), new LinkOption[0])) {
            dialog.setFilterPath(USER_HOME);
        }
        String actualFileName = LogCollector.archiveFileName();
        dialog.setFileName(actualFileName);
        String destination = dialog.open();
        if (destination != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Destination for saving log files is {}", (Object)destination);
            }
            try {
                LogCollector.archiveLogs((String)destination);
            }
            catch (Throwable t) {
                LOGGER.error("Could not save log files to ZIP", t);
                ExceptionUtils.logAndShowError((String)"Could not save log files to ZIP", (Throwable)t);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No destination selected for saving logs");
        }
    }
}

