package org.simantics.layer0;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class RequirementResource {
    
    public final Resource AllValuesSatisfy;
    public final Resource AllValuesSatisfy_Inverse;
    public final Resource EqualityRequirement;
    public final Resource HasEntity;
    public final Resource HasMultiplicity;
    public final Resource HasMultiplicity_Inverse;
    public final Resource HasRequirement;
    public final Resource HasRequirement_Inverse;
    public final Resource HasType;
    public final Resource HasValueRequirement;
    public final Resource HasValueRequirement_Inverse;
    public final Resource Ignore;
    public final Resource IntegerRangeUnion;
    public final Resource RelationRequirement;
    public final Resource Requirement;
    public final Resource RequirementConjunction;
    public final Resource RequirementDisjunction;
    public final Resource RequirementNegation;
    public final Resource Requires;
    public final Resource SomeValuesSatisfy;
    public final Resource SomeValuesSatisfy_Inverse;
    public final Resource TypeRequirement;
    public final Resource ValueRequirement;
    public final Resource ValueType;
        
    public static class URIs {
        public static final String AllValuesSatisfy = "http://www.simantics.org/Layer0X-1.1/Requirement/AllValuesSatisfy";
        public static final String AllValuesSatisfy_Inverse = "http://www.simantics.org/Layer0X-1.1/Requirement/AllValuesSatisfy/Inverse";
        public static final String EqualityRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/EqualityRequirement";
        public static final String HasEntity = "http://www.simantics.org/Layer0X-1.1/Requirement/HasEntity";
        public static final String HasMultiplicity = "http://www.simantics.org/Layer0X-1.1/Requirement/HasMultiplicity";
        public static final String HasMultiplicity_Inverse = "http://www.simantics.org/Layer0X-1.1/Requirement/HasMultiplicity/Inverse";
        public static final String HasRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/HasRequirement";
        public static final String HasRequirement_Inverse = "http://www.simantics.org/Layer0X-1.1/Requirement/HasRequirement/Inverse";
        public static final String HasType = "http://www.simantics.org/Layer0X-1.1/Requirement/HasType";
        public static final String HasValueRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/HasValueRequirement";
        public static final String HasValueRequirement_Inverse = "http://www.simantics.org/Layer0X-1.1/Requirement/HasValueRequirement/Inverse";
        public static final String Ignore = "http://www.simantics.org/Layer0X-1.1/Requirement/Ignore";
        public static final String IntegerRangeUnion = "http://www.simantics.org/Layer0X-1.1/Requirement/IntegerRangeUnion";
        public static final String RelationRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/RelationRequirement";
        public static final String Requirement = "http://www.simantics.org/Layer0X-1.1/Requirement/Requirement";
        public static final String RequirementConjunction = "http://www.simantics.org/Layer0X-1.1/Requirement/RequirementConjunction";
        public static final String RequirementDisjunction = "http://www.simantics.org/Layer0X-1.1/Requirement/RequirementDisjunction";
        public static final String RequirementNegation = "http://www.simantics.org/Layer0X-1.1/Requirement/RequirementNegation";
        public static final String Requires = "http://www.simantics.org/Layer0X-1.1/Requirement/Requires";
        public static final String SomeValuesSatisfy = "http://www.simantics.org/Layer0X-1.1/Requirement/SomeValuesSatisfy";
        public static final String SomeValuesSatisfy_Inverse = "http://www.simantics.org/Layer0X-1.1/Requirement/SomeValuesSatisfy/Inverse";
        public static final String TypeRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/TypeRequirement";
        public static final String ValueRequirement = "http://www.simantics.org/Layer0X-1.1/Requirement/ValueRequirement";
        public static final String ValueType = "http://www.simantics.org/Layer0X-1.1/Requirement/ValueType";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public RequirementResource(ReadGraph graph) {
        AllValuesSatisfy = getResourceOrNull(graph, URIs.AllValuesSatisfy);
        AllValuesSatisfy_Inverse = getResourceOrNull(graph, URIs.AllValuesSatisfy_Inverse);
        EqualityRequirement = getResourceOrNull(graph, URIs.EqualityRequirement);
        HasEntity = getResourceOrNull(graph, URIs.HasEntity);
        HasMultiplicity = getResourceOrNull(graph, URIs.HasMultiplicity);
        HasMultiplicity_Inverse = getResourceOrNull(graph, URIs.HasMultiplicity_Inverse);
        HasRequirement = getResourceOrNull(graph, URIs.HasRequirement);
        HasRequirement_Inverse = getResourceOrNull(graph, URIs.HasRequirement_Inverse);
        HasType = getResourceOrNull(graph, URIs.HasType);
        HasValueRequirement = getResourceOrNull(graph, URIs.HasValueRequirement);
        HasValueRequirement_Inverse = getResourceOrNull(graph, URIs.HasValueRequirement_Inverse);
        Ignore = getResourceOrNull(graph, URIs.Ignore);
        IntegerRangeUnion = getResourceOrNull(graph, URIs.IntegerRangeUnion);
        RelationRequirement = getResourceOrNull(graph, URIs.RelationRequirement);
        Requirement = getResourceOrNull(graph, URIs.Requirement);
        RequirementConjunction = getResourceOrNull(graph, URIs.RequirementConjunction);
        RequirementDisjunction = getResourceOrNull(graph, URIs.RequirementDisjunction);
        RequirementNegation = getResourceOrNull(graph, URIs.RequirementNegation);
        Requires = getResourceOrNull(graph, URIs.Requires);
        SomeValuesSatisfy = getResourceOrNull(graph, URIs.SomeValuesSatisfy);
        SomeValuesSatisfy_Inverse = getResourceOrNull(graph, URIs.SomeValuesSatisfy_Inverse);
        TypeRequirement = getResourceOrNull(graph, URIs.TypeRequirement);
        ValueRequirement = getResourceOrNull(graph, URIs.ValueRequirement);
        ValueType = getResourceOrNull(graph, URIs.ValueType);
    }
    
    public static RequirementResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        RequirementResource ret = session.peekService(RequirementResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new RequirementResource(qc.getIndependentGraph(graph));
            session.registerService(RequirementResource.class, ret);
        }
        return ret;
    }
    
    public static RequirementResource getInstance(RequestProcessor session) throws DatabaseException {
        RequirementResource ret = session.peekService(RequirementResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<RequirementResource>() {
                public RequirementResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new RequirementResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(RequirementResource.class, ret);
        }
        return ret;
    }
    
}

