/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.db.ChangeSet;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.XSupport;

public class ManagementSupportImpl
implements ManagementSupport {
    private final SessionImplSocket session;

    ManagementSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public Collection<ChangeSet> fetchChangeSets(ReadGraph graph, final long min, final long max) throws DatabaseException {
        if (min < 1L || min > max) {
            throw new IllegalArgumentException("Illegal range: min=" + min + " max=" + max);
        }
        return (Collection)graph.sync((ReadInterface)new UniqueRead<Collection<ChangeSet>>(){

            public Collection<ChangeSet> perform(ReadGraph graph) throws DatabaseException {
                int size = (int)(max - min + 1L);
                ClientChangesImpl csi = new ClientChangesImpl(ManagementSupportImpl.this.session);
                SynchronizeContext context = new SynchronizeContext(ManagementSupportImpl.this.session, csi, size, true);
                boolean failed = ((ManagementSupportImpl)ManagementSupportImpl.this).session.graphSession.getChangeSets(min, max, context);
                if (failed) {
                    throw new InternalException("Trouble with server execution.");
                }
                if (!context.isOk(false)) {
                    throw new InternalException("Trouble with server reply.");
                }
                return context.getChangeSets();
            }
        });
    }

    public Collection<ChangeSetIdentifier> getChangeSetIdentifiers(long from, long to) throws DatabaseException {
        return this.session.graphSession.getChangeSets(from, to, this.session.state.getHeadRevisionId());
    }

    @Deprecated
    public Collection<ChangeSetIdentifier> getChangeSets(long from, long to) throws DatabaseException {
        return this.session.graphSession.getChangeSets(from, to, this.session.state.getHeadRevisionId());
    }

    public <T> Collection<T> getMetadata(ReadGraph graph, long from, long to, Class<? extends Metadata> dataClass) throws DatabaseException {
        return this.getMetadata(from, to, dataClass);
    }

    public <T> Collection<T> getMetadata(long from, long to, Class<? extends Metadata> dataClass) throws DatabaseException {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            Method m = dataClass.getMethod("deserialise", Session.class, byte[].class);
            Collection<ChangeSetIdentifier> css = this.getChangeSets(from, to);
            for (ChangeSetIdentifier cs : css) {
                byte[] result;
                Map md = cs.getMetadata();
                if (md == null || (result = (byte[])md.get(dataClass.getName())) == null) continue;
                try {
                    Object value = m.invoke(null, this.session, result);
                    results.add(value);
                }
                catch (SecurityException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Logger.defaultLogError((Throwable)e.getCause());
                }
            }
        }
        catch (SecurityException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return results;
    }

    public void dumpRevision(long lastChangeSetId) throws DatabaseException {
        XSupport xs = this.session.getService(XSupport.class);
        String s = xs.execute("dumpRevision " + lastChangeSetId);
        long outChangeSetId = Long.parseLong(s);
        if (lastChangeSetId > 0L && outChangeSetId != lastChangeSetId) {
            throw new DatabaseException("Failed to dump revision=" + lastChangeSetId + ":\n" + s);
        }
    }

    public void dumpChangeSets(long lastChangeSetId) throws DatabaseException {
        XSupport xs = this.session.getService(XSupport.class);
        String s = xs.execute("dumpChangeSets " + lastChangeSetId);
        long outChangeSetId = Long.parseLong(s);
        if (lastChangeSetId > 0L && outChangeSetId != lastChangeSetId) {
            throw new DatabaseException("Failed to dump revision=" + lastChangeSetId + ":\n" + s);
        }
    }

    public long getHeadRevisionId() throws DatabaseException {
        return this.session.state.getHeadRevisionId();
    }

    public long getFirstRevisionId() throws DatabaseException {
        return this.session.graphSession.dbSession.getDatabase().serverGetTailChangeSetId();
    }

    public void subscribe(ManagementSupport.ChangeSetListener changeSetListener) {
        this.session.graphSession.addChangeSetListener(changeSetListener);
    }

    public void cancel(ManagementSupport.ChangeSetListener changeSetlistener) {
        this.session.graphSession.removeChangeSetListener(changeSetlistener);
    }
}

