package org.simantics.db.procore.ui.internal;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.utils.Logger;

public class Util {
    static void showInfo(Shell shell, String message) {
        MessageDialog.openInformation(shell, "Information", message);
    }
    static void showWarning(Shell shell, String message) {
        MessageDialog.openWarning(shell, "Warning", message);
    }
    public static void showError(Shell shell, String message) {
        Util.showError(shell, message, null);
    }
    static void showError(Shell shell, String message, Throwable t) {
        Logger.defaultLogError(message, t);
        if (null != t)
            message += "\n" + t.getMessage();
        MessageDialog.openError(shell, "Error", message);
    }
    public static void logError(String message) {
        Util.logError(message, null);
    }
    public static void logError(String message, Throwable cause) {
        Logger.defaultLogError(message, cause);
    }
    public static void trace(Class<?> clazz) {
        trace(clazz, null);
    }
    public static void trace(String message) {
        trace(null, message);
    }
    public static void trace(Class<?> clazz, String message) {
        String s = "";
        if (null != clazz)
            s += clazz.getSimpleName() + " called.\n";
        if (null != message)
            s += message;
        Logger.defaultLogTrace(s);
    }
    private static String NL = System.getProperty("line.separator");
    static class Choice {
        public Choice(String button, String text) {
            this.button = button;
            this.text = text;
        }
        public String button;
        public String text;
    }
    public static int select(final Shell shell, final String title, String message, Choice[] choices, int def) {
        assert(choices.length > 0);
        if (def < 0 || def >= choices.length)
            def = 0;
        final String[] labels = new String[choices.length];
        final StringBuilder sb = new StringBuilder(message.length() + 256);
        sb.append(message);
        for (int i=0; i<labels.length; ++ i) {
            labels[i] = choices[i].button;
            sb.append(NL + NL + choices[i].text);
        }
        if (Display.getDefault().getThread() == Thread.currentThread())
            return select(shell, title, sb.toString(), labels, def);
        class SelectRunnable implements Runnable {
            int ret;
            int def;
            SelectRunnable(int def) {
                this.def = def;
            }
            public void run() {
                ret = select(shell, title, sb.toString(), labels, def);
            }
        };
        SelectRunnable sr = new SelectRunnable(def);
        Display.getDefault().syncExec(sr);
        return sr.ret;
    }
    private static int select(Shell shell, String title, String message, String[] labels, int def) {
        MessageDialog dialog = new MessageDialog(shell, title, null, message, MessageDialog.QUESTION, labels, def);
        int answer = dialog.open();
        if (answer < 0 || answer >= labels.length)
            answer = 0;
        return answer;
    }
    public static boolean confirm(Shell shell, String title, String message) {
        String[] labels = new String[2];
        labels[0] =  "Yes";
        labels[1] = "No";
        MessageDialog dialog = new MessageDialog(shell, title, null, message, MessageDialog.QUESTION, labels, 1);
        int answer = dialog.open();
        return answer == 0;
    }
    public static boolean openDefaultNo(Shell shell, String title, String message, int style) {
        String[] labels = new String[2];
        labels[0] =  "Yes";
        labels[1] = "No";
        MessageDialog dialog = new MessageDialog(shell, title, null, message, style, labels, 1);
        int answer = dialog.open();
        return answer == 0;
    }
    public static String getMessage(Throwable t) {
        StringBuilder s = new StringBuilder(t.getMessage());
        final int LIMIT = 10;
        int i = 0;
        for (Throwable c = t.getCause(); null != c && i < LIMIT; ++i, c = c.getCause())
            s.append(NL + "cause: " + c.getMessage());
        return s.toString();
    }
}
