/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.request.RequestFlags;

abstract public class StringQuery<Procedure> extends CacheEntryBase implements Query {

    final public String id;
    final public int hash;

    public StringQuery(String id) {
        assert(id != null);
    	this.id = id;
    	hash = id.hashCode();
    }
    
    @Override
    int makeHash() {
    	return id.hashCode();
    }
    
    final protected static int hash(String id) {
        return id.hashCode();
    }
    
    @Override
    public int type() {
        return RequestFlags.INVALIDATE;
    }
    
    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        StringQuery other = (StringQuery)object;
        return id == other.id;
    }
    
    @Override
    final public Query getQuery() {
        return this;
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
        throw new Error("Recompute of primitive queries is not supported.");
    }
    
    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
    	throw new Error("Not possible.");
    }
    
    abstract public void recompute(ReadGraphImpl graph, QueryProcessor provider);
    abstract public void computeForEach(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure);
    abstract public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure);
    abstract public void putEntry(QueryProcessor provider);
    abstract public void removeEntry(QueryProcessor provider);
    abstract public StringQuery<Procedure> getEntry(QueryProcessor provider);
	
}
