package org.simantics.color;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ColorResource {
    
    public final Resource RGB;
        
    public static class URIs {
        public static final String RGB = "http://www.simantics.org/Color-1.1/RGB";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ColorResource(ReadGraph graph) {
        RGB = getResourceOrNull(graph, URIs.RGB);
    }
    
    public static ColorResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ColorResource ret = session.peekService(ColorResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ColorResource(qc.getIndependentGraph(graph));
            session.registerService(ColorResource.class, ret);
        }
        return ret;
    }
    
    public static ColorResource getInstance(RequestProcessor session) throws DatabaseException {
        ColorResource ret = session.peekService(ColorResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ColorResource>() {
                public ColorResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ColorResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ColorResource.class, ret);
        }
        return ret;
    }
    
}

