/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.set.ImmutableSet;

/**
 * This file was automatically generated from template file immutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface ImmutableIntSet extends ImmutableIntCollection, IntSet
{
    ImmutableIntSet select(IntPredicate predicate);

    ImmutableIntSet reject(IntPredicate predicate);

    <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function);

    ImmutableIntSet newWith(int element);

    ImmutableIntSet newWithout(int element);

    ImmutableIntSet newWithAll(IntIterable elements);

    ImmutableIntSet newWithoutAll(IntIterable elements);
}
