/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleList extends MutableDoubleCollection, DoubleList
{
    void addAtIndex(int index, double element);

    boolean addAllAtIndex(int index, double... source);

    boolean addAllAtIndex(int index, DoubleIterable source);

    double removeAtIndex(int index);

    double set(int index, double element);

    MutableDoubleList select(DoublePredicate predicate);

    MutableDoubleList reject(DoublePredicate predicate);

    MutableDoubleList with(double element);

    MutableDoubleList without(double element);

    MutableDoubleList withAll(DoubleIterable elements);

    MutableDoubleList withoutAll(DoubleIterable elements);

    <V> MutableList<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleList reverseThis();

    MutableDoubleList toReversed();

    /**
     * @since 6.0.
     */
    MutableDoubleList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableDoubleList sortThis();

    MutableDoubleList asUnmodifiable();

    MutableDoubleList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableDoubleList toImmutable();

    MutableDoubleList subList(int fromIndex, int toIndex);
}
