/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableLongList extends ImmutableLongCollection, LongList
{
    ImmutableLongList select(LongPredicate predicate);

    ImmutableLongList reject(LongPredicate predicate);

    <V> ImmutableList<V> collect(LongToObjectFunction<? extends V> function);

    ImmutableLongList newWith(long element);

    ImmutableLongList newWithout(long element);

    ImmutableLongList newWithAll(LongIterable elements);

    ImmutableLongList newWithoutAll(LongIterable elements);

    ImmutableLongList toReversed();

    /**
     * @since 6.0.
     */
    ImmutableLongList distinct();

    ImmutableLongList subList(int fromIndex, int toIndex);
}
