/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph.parser.ast;

import org.simantics.spreadsheet.graph.PrintVisitor;

public class AstTerm extends AstList {

	private static final long serialVersionUID = 5149262360878090713L;

	public AstTerm(AstValue left) {
		super(left);
	}
	
	@Override
	public <T> T accept(AstValueVisitor<T> v) {
		return v.visit(this);
	}
	
	@Override
	public String toString() {
		return accept(new PrintVisitor());
	}
	
}
