/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph.parser.ast;

import org.simantics.spreadsheet.graph.PrintVisitor;

public class AstRange implements AstValue {
	
	private static final long serialVersionUID = -2612788686679843356L;

	public static final AstRange REF = new AstRange("#REF!");

	public String sheetName;
	public String first;
	public String second;

	public AstRange(String sheetName, String first, String second) {
		this.sheetName = sheetName;
		this.first = first;
		this.second = second;
	}

	public AstRange(String token) {
		String[] parts = token.split(":");
		if(parts.length == 2) {
			this.first = parts[0];
			this.second = parts[1];
		} else {
			this.first = token;
		}
	}
	
	@Override
	public <T> T accept(AstValueVisitor<T> v) {
		return v.visit(this);
	}

	public boolean isCell() {
		return second == null;
	}
	
	public boolean isRef() {
		return second==null && "#REF!".equals(first);
	}
	
	public AstRange inSheet(String sheetName) {
		AstRange range = new AstRange(sheetName, first, second);
		return range;
	}
	
	@Override
	public String toString() {
		return accept(new PrintVisitor());
	}
	
}
