package org.simantics.spreadsheet.graph.formula;

import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

public class TodayFormulaFunction implements CellFormulaFunction<Long> {

    private Temporal baseline = LocalDate.of(1899, Month.DECEMBER, 30);

    @Override
    public Long evaluate(CellValueVisitor visitor, AstArgList args) {
        return Long.valueOf(ChronoUnit.DAYS.between(baseline, LocalDate.now()));
    }

}
