package org.simantics.spreadsheet.graph.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class StringArrayCells implements VariableFactory {

	private Resource configuration;
	
	public StringArrayCells(Resource configuration) {
		this.configuration = configuration;
	}

	final String[] propertyNames = { Variables.LABEL, "immutable" }; 
	final Binding[] bindings = { Bindings.STRING, Bindings.BOOLEAN };
	
	private Collection<Variable> toVariables(ReadGraph graph, Variable variable, String[] data, int width) throws DatabaseException {

		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		String location = graph.getPossibleRelatedValue(configuration, sr.HasLocation, Bindings.STRING);
		if(location == null) return Collections.emptyList();
		
		int rows = data.length / width;
		
		ArrayList<Variable> result = new ArrayList<Variable>();
		for(int offset=0,i=0;i<rows;i++) {
			for(int j=0;j<width;j++) {
				String value = data[offset++];
				String valueLocation = SpreadsheetUtils.offset(location, i, j);
				result.add(new ConstantChildVariable(variable, valueLocation, propertyNames, bindings, new Object[] { value, true }));
			}
		}
		return result;

	}
	
	private Collection<Variable> error(ReadGraph graph, Variable variable, String message) throws DatabaseException {

		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		String location = graph.getPossibleRelatedValue(configuration, sr.HasLocation, Bindings.STRING);
		if(location == null) return Collections.emptyList();
		
		return Collections.<Variable>singletonList(new ConstantChildVariable(variable, location, propertyNames, bindings, new Object[] { message })); 

	}
	
	@Override
	public Collection<Variable> evaluate(ReadGraph graph, Variable variable) throws DatabaseException {
		
		SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
		String[] data = graph.getPossibleRelatedValue(configuration, sr.StringArrayCell_HasStringArray, Bindings.STRING_ARRAY);
		if(data == null) return error(graph, variable, "No string array data.");
		Integer width = graph.getPossibleRelatedValue(configuration, sr.StringArrayCell_HasWidth, Bindings.INTEGER);
		if(width == null) return error(graph, variable, "Invalid width for string array.");
			
		return toVariables(graph, variable, data, width);
		
	}
	
}
