package org.simantics.spreadsheet.graph;

import java.io.Serializable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;

public class SpreadsheetSCLConstant implements Serializable {

    private static final long serialVersionUID = 428064772427245449L;

    public String expression;
    public Object content;
    
    public static final Binding BINDING = Bindings.getBindingUnchecked(SpreadsheetSCLConstant.class);

    public SpreadsheetSCLConstant(String expression, Object object) {
        this.content = object;
        this.expression = expression;
    }
    
    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((expression == null) ? 0 : expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetSCLConstant other = (SpreadsheetSCLConstant) obj;
        if (expression == null) {
            if (other.expression != null)
                return false;
        } else if (!expression.equals(other.expression))
            return false;
        return true;
    }

}
