package org.simantics.spreadsheet.graph;

import org.simantics.db.layer0.StandardNodeManager;
import org.simantics.db.layer0.StandardRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetRealm extends StandardRealm<SheetNode,SpreadsheetBook> {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetRealm.class);
    
	SpreadsheetRealm(SpreadsheetBook book, String id) {
		super(book, id);
	}

	@Override
	protected StandardNodeManager<SheetNode, SpreadsheetBook> createManager() {
		return new SpreadsheetNodeManager(this);
	}

    @Override
    public Logger getLogger() {
        return LOGGER;
    }
    
}
