package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.Set;

import org.simantics.db.layer0.StandardNodeManager;
import org.simantics.layer0.Layer0;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.structural.stubs.StructuralResource2;

@SuppressWarnings("rawtypes")
public class SpreadsheetNodeManager extends StandardNodeManager<SheetNode, SpreadsheetBook> {
	
    public SpreadsheetNodeManager(SpreadsheetRealm realm) {
        super(realm, realm.getEngine());
    }

    static final Set<String> COMPONENT_CLASS = Collections.singleton(StructuralResource2.URIs.Component);
            
    @Override
    public Set<String> getClassifications(SheetNode node) throws NodeManagerException {
        checkThreadAccess();
        if(isRoot(node))
            return COMPONENT_CLASS;
        else
            return Collections.emptySet();
    }
    
    @Override
    public String getPropertyURI(SheetNode parent, SheetNode property) {
    	if(property instanceof SpreadsheetCellContent) {
            return SpreadsheetResource.URIs.Cell_content;
    	} else if(property instanceof SpreadsheetTypeNode) {
            return Layer0.URIs.typeURI;
    	} else if(property instanceof SpreadsheetCellContentExpression) {
            return Layer0.URIs.SCLValue_expression;
    	} else if (property instanceof SpreadsheetCellStyle) {
    	    return SpreadsheetResource.URIs.Cell_style;
    	} else if (property instanceof SpreadsheetCellEditable){
    	    return SpreadsheetResource.URIs.Cell_editable;
    	} else {
    		return null;
    	}
    }
    
}
