package org.simantics.spreadsheet.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;

public interface SpreadsheetElement<Child extends SpreadsheetElement<?, ?>, Parent extends SpreadsheetElement<?, ?>> extends SpreadsheetVisitable, Serializable {

    Optional<Parent> getParent();

    Collection<Child> getSpreadsheetChildren();

    void remove(Child child);

}
