/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import java.io.IOException;

import org.simantics.db.ServerI;
import org.simantics.db.VirtualGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.service.ServerInformation;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.SessionManagerSource;

public class SessionImplVirtual extends SessionImplSocket {
    protected VirtualGraphImpl virtualGraphImpl;
    public SessionImplVirtual(UserAuthenticationAgent authAgent)
    throws DatabaseException {
        super(null, authAgent);
        init(authAgent, false);
    }
    public SessionImplVirtual(UserAuthenticationAgent authAgent, boolean init)
    throws DatabaseException {
        super(null, authAgent);
        init(authAgent, init);
    }
    private void init(UserAuthenticationAgent authAgent, boolean init)
    throws DatabaseException {
        ProCoreServerReference serverReference = new ProCoreServerReference();
        ProCoreSessionReference sessionReference = new ProCoreSessionReference(serverReference, SessionManagerSource.NullSessionId);
        if (init)
            graphSession = new GraphSessionVirtualInit(this, sessionReference, virtualGraphServerSupport);
        else
            graphSession = new GraphSessionVirtual(this, sessionReference, virtualGraphServerSupport);
        // This is used by QueryProcessor among others.
        String databaseId = GraphSessionVirtual.serverInfo.databaseId;
        String serverId = GraphSessionVirtual.serverInfo.serverId;
        try {
            virtualGraphServerSupport.connect(databaseId + "." + serverId);
            virtualGraphImpl = (VirtualGraphImpl)virtualGraphServerSupport.getWorkspacePersistent("virtualGraph" + "." + serverId);
            requestManager = new SessionRequestManager(this, state);
            clusterStream = new ClusterStream(this, graphSession, true);
            clusterTranslator = new ClusterTranslatorImpl(this);
            writeSupport = new WriteSupportImpl(this);
            resourceSupport = new ResourceSupportImpl(this);
            querySupport = new QuerySupportImpl(this, clusterTranslator, new SerialisationSupportImpl(this), requestManager);
            queryProvider2 = new QueryProcessor(getAmountOfQueryThreads(), querySupport, sessionThreads);
            state.setGraphSession(this, graphSession, queryProvider2, clusterTable);
            ServerInformationImpl serverInfo = graphSession.getServerInformation();
            authenticator = authAgent.getAuthenticator(serverInfo);
            if (authenticator == null)
                throw new InvalidAuthenticationException("Authentication agent did not provide an authenticator");
            if (authenticator instanceof BackdoorAuthenticator)
                user = authenticator.getUser(this);
        } catch (InvalidAuthenticationException e) {
            throw e;
        } catch (InvalidUserException e) {
            throw e;
        } catch (IOException e) {
        	Logger.defaultLogError("I/O error. See exception for details.", e);
            graphSession = null;
            throw new DatabaseException(e);
        } catch (Throwable e) {
            e.printStackTrace();
            Logger.defaultLogError("Unhandled error. See exception for details.", e);
            graphSession = null;
            throw new DatabaseException(e);
        }
        this.clusterStream.setOff(true);
    }
    public static ServerI newVirtualProCoreServer() {
        if (DEBUG)
            System.out.println("SessionImplVirtual.newVirtualProCoreServer");
        return new VirtualServer();
    }
    @Override
    protected VirtualGraph getProvider(VirtualGraph vg) {
        return null != vg ? vg : virtualGraphImpl;
    }
    @Override
    protected ResourceImpl getNewResource() throws DatabaseException {
        int newId = virtualGraphImpl.newResource(false);
        return new ResourceImpl(resourceSupport, newId);
    }
    @Override
    protected ServerInformation getCachedServerInformation() {
        GraphSession gs = graphSession;
        if (null == gs)
            return null;
        try {
            return gs.getServerInformation();
        } catch (DatabaseException e) {
            Logger.defaultLogError("Failed to get server info.", e);
            return null;
        }
    }
}
