/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ResourceImpl;

public class NewStatementImpl implements Statement {

    public final ResourceImpl subject;
    public final ResourceImpl predicate;
    public final ResourceImpl object;
    
    public NewStatementImpl(int id, ResourceImpl subject, ResourceImpl predicate, ResourceImpl object) {
        if (null == subject)
            throw new IllegalArgumentException();
        if(null == predicate)
            throw new IllegalArgumentException();
        if(null == object)
            throw new IllegalArgumentException();
        this.subject = (ResourceImpl)subject;
        this.predicate = (ResourceImpl)predicate;
        this.object = (ResourceImpl)object;
    }
    @Override
    final public Resource getObject() {
        return object;
    }

    @Override
    final public Resource getPredicate() {
        return predicate;
    }

    @Override
    final public Resource getSubject() {
        return subject;
    }

    public int hashCode()
    {
    	// TODO: :)
        int result = 6151 * ((int)(subject.id ^ (subject.id>>>32))*6151 + 
        (int)(predicate.id ^ (predicate.id>>>32))) +
        (int)(object.id ^ (object.id>>>32)); 
        return result;
        
    }

    @Override
    public boolean isAsserted(Resource testSubject) {
    	return !subject.equals(testSubject);
    }
    
    public boolean equals(Object object)
    {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        try {
            Statement r = (Statement)object;
            return subject.id == r.getSubject().getResourceId() &&
            predicate.id == r.getPredicate().getResourceId() &&
            this.object.id == r.getObject().getResourceId();
        } catch (ClassCastException e) {
            return false;
        }
    }
    
    
}
