/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Obtained with Variable.adapt
 */
public interface VariableSpaceManipulator {

    public class PropertyCreationData {
    	public String name;
    	public Variant value;
        public PropertyCreationData(String name, Variant value) {
            this.name = name;
            this.value = value;
        }
        
		public static PropertyCreationData build(String name, Object value) {
			return new PropertyCreationData(name, Variant.ofInstance(value));
		}
        
    }
	
    public class ChildCreationData {
    	public String type;
    	public String name;
        public PropertyCreationData[] properties;
        public ChildCreationData(String name, String type, PropertyCreationData[] properties) {
            this.name = name;
            this.type = type;
            this.properties = properties;
        }
        
		public static ChildCreationData build(String name, String type, PropertyCreationData ... properties) {
			return new ChildCreationData(name, type, properties);
		}
        
    }

    public class Modification {

		public String[] removedProperties;
		public String[] removedChildren;
		public PropertyCreationData[] newProperties;
		public ChildCreationData[] newChildren;
		
		public Modification(String[] removedProperties, String[] removedChildren, PropertyCreationData[] newProperties, ChildCreationData[] newChildren) {
			this.removedProperties = removedProperties;
			this.removedChildren = removedChildren;
			this.newProperties = newProperties;
			this.newChildren = newChildren;
		}
		
		public static Modification build(Collection<String> removedProperties, Collection<String> removedChildren, Collection<PropertyCreationData> newProperties, Collection<ChildCreationData> newChildren) {
			return new Modification(
					removedProperties.toArray(new String[removedProperties.size()]),
					removedChildren.toArray(new String[removedChildren.size()]),
					newProperties.toArray(new PropertyCreationData[newProperties.size()]),
					newChildren.toArray(new ChildCreationData[newChildren.size()]));
		}

		public static Modification buildChildren(Collection<String> removedChildren, Collection<ChildCreationData> newChildren) {
			return new Modification(
					new String[0], removedChildren.toArray(new String[removedChildren.size()]),
					new PropertyCreationData[0], newChildren.toArray(new ChildCreationData[newChildren.size()]));
		}
		
		public static Modification addChildren(Collection<ChildCreationData> newChildren) {
			return new Modification(
					new String[0], new String[0],
					new PropertyCreationData[0], newChildren.toArray(new ChildCreationData[newChildren.size()]));
		}

		public static Modification addChild(ChildCreationData child) {
			return addChildren(Collections.singletonList(child));
		}

		public static Modification removeChildren(Collection<String> removedChildren) {
			return new Modification(
					new String[0], removedChildren.toArray(new String[removedChildren.size()]),
					new PropertyCreationData[0], new ChildCreationData[0]);
		}

		public static Modification removeChild(String child) {
			return removeChildren(Collections.singletonList(child));
		}
		
		public static Modification addProperties(Collection<PropertyCreationData> newProperties) {
			return new Modification(
					new String[0], new String[0],
					newProperties.toArray(new PropertyCreationData[newProperties.size()]), new ChildCreationData[0]);
		}
		
		public static Modification addProperty(PropertyCreationData property) {
			return addProperties(Collections.singletonList(property));
		}
		
	}
	
    void apply(WriteGraph graph, Modification modification) throws DatabaseException;
	
//	Variable createChild(WriteGraph graph, String name, Object content) throws DatabaseException;
//	Variable createProperty(WriteGraph graph, String name) throws DatabaseException;
//	Variable createVariable(WriteGraph graph, String rvi) throws DatabaseException;
//	
//	Variable removeChild(WriteGraph graph, String name) throws DatabaseException;
	
}
