/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ResourceURIToVariable;
import org.simantics.db.layer0.request.VariableURI;

/**
 * This class binds Variable to StringType
 *
 * @author toni.kalajainen
 */
public class VariableBinding extends StringBinding {

    Session session;

    public VariableBinding(Session session) {
        super(Datatypes.STRING);
        this.session = session;
    }

    @Override
    public boolean isImmutable() {
    	return true;
    }

	@Override
	public Object create(String value) throws BindingException {
		if ( session == null ) throw new BindingException("Cannot create Variable without a Session");
		try {
			return session.sync( new ResourceURIToVariable( value ) );
		} catch (DatabaseException e) {
			throw new BindingException(e);
		}
	}

	@Override
	public String getValue(Object o) throws BindingException {
		if ( session == null ) throw new BindingException("Cannot create Variable without a Session");
		if (o instanceof Variable==false) throw new BindingException("Not a variable");
		Variable v = (Variable) o;
		try {
			return (String) session.sync( new VariableURI( v ) );
		} catch (DatabaseException e) {
			throw new BindingException( e );
		}
	}

	@Override
	public void setValue(Object o, String newValue) throws BindingException {
		throw new BindingException("Cannot set URI to Variable. URI is immutable");
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof Variable;
	}

}
