package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function3;

public class SCLValueAccessor implements ValueAccessor {

	private final Function1<Variable,Object> getValue1;
	private final Function2<Variable,Binding,Object> getValue2;
	private final Function2<Variable,Object,Object> setValue2;
	private final Function3<Variable,Object,Binding,Object> setValue3;
	private final Function1<Variable,Datatype> getDatatype;
	
	public SCLValueAccessor(Function1<Variable, Object> getValue1, Function2<Variable, Binding, Object> getValue2,
			Function2<Variable, Object, Object> setValue2, Function3<Variable, Object, Binding, Object> setValue3,
			Function1<Variable, Datatype> getDatatype) {
		this.getValue1 = getValue1;
		this.getValue2 = getValue2;
		this.setValue2 = setValue2;
		this.setValue3 = setValue3;
		this.getDatatype = getDatatype;
	}

	@Override
	public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put("graph", graph);
        try {
            return getValue1.apply(context);
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
	}

	@Override
	public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put("graph", graph);
        try {
            return getValue2.apply(context, binding);
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
	}

	@Override
	public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put("graph", graph);
        try {
            setValue2.apply(context, value);
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
	}

	@Override
	public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put("graph", graph);
        try {
            setValue3.apply(context, value, binding);
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
	}

	@Override
	public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put("graph", graph);
        try {
            return getDatatype.apply(context);
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
	}

}
