/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.utils.datastructures.collections.CollectionUtils;

final public class SimanticsClipboardImpl implements SimanticsClipboard, SimanticsClipboardBuilder {
	
	final private ArrayList<Set<Representation>> objects = new ArrayList<Set<Representation>>(); 

	public SimanticsClipboardImpl() {
	}
	
	public SimanticsClipboardImpl(Representation representation) {
		addContent(Collections.singleton(representation));
	}

	public SimanticsClipboardImpl(Representation ... representation) {
		addContent(CollectionUtils.toSet(representation));
	}

	@Override
	public Collection<Set<Representation>> getContents() {
		return objects;
	}

	@Override
	public void addContent(Set<Representation> content) {
		objects.add(content);
	}
	
	static SimanticsClipboard single(Representation representation) {
		return new SimanticsClipboardImpl(representation);
	}

	static SimanticsClipboard make(Representation ... representations) {
		return new SimanticsClipboardImpl(representations);
	}

}
