/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoots;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleModel extends ResourceRead<Resource> {

    public PossibleModel(Resource resource) {
        super(resource);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {

        SimulationResource SIMU = SimulationResource.getInstance(graph);
        if (graph.isInstanceOf(resource, SIMU.Model))
            return resource;

        Collection<Resource> result = graph.sync(new IndexRoots(resource));
        if(result.size() == 1) {
            Resource res = result.iterator().next(); 
            if (graph.isInstanceOf(res, SIMU.Model))
                return res;
        }
        return null;
        
//    	SimulationResource SIMU = SimulationResource.getInstance(graph);
//    	Layer0 L0 = Layer0.getInstance(graph);
//    	
//        if (graph.isInstanceOf(resource, SIMU.Model))
//            return resource;
//        
//        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
//        if (parent == null)
//            return null;
//        
//        else return graph.syncRequest(new PossibleModel(parent));

    }

}
