package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class HasEnumerationRange extends ResourceRead<Boolean> {

	public HasEnumerationRange(Resource resource) {
		super(resource);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		for(Resource range : graph.getObjects(resource, L0.HasRange)) {
			boolean enu = graph.syncRequest(new IsEnumeratedType(range));
			if(enu) return true;
		}
		return false;
	}

}
