/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.utils.datastructures.Pair;

/**
 * Default implementation for some methods of IRelation interface.
 */
public class UnsupportedRelation implements GenericRelation {

	@Override
	public boolean contains(ReadGraph graph, Object[] tuple) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean isRealizable() {
		throw new UnsupportedOperationException();
	}

	@Override
	public List<Object[]> realize(ReadGraph graph) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public GenericRelation select(String bindingPattern, Object[] constants) {
		throw new UnsupportedOperationException();
	}

	@Override
	public GenericRelation selectByRelation(String bindingPattern,
			GenericRelation constraint) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Pair<String, String>[] getFields() {
		throw new UnsupportedOperationException();
	}

	private Class<?> getClass(String clazz) {
		if("Long".equals(clazz)) return Long.class;
		else return String.class;
	}
	
	protected void checkSelectionArguments(String bindingPattern, Object[] constants, String[] allowedPatterns) {

        boolean allowed = false;
        for(String allow : allowedPatterns) {
        	if(allow.equals(bindingPattern)) {
            	allowed = true;
            	break;
            }
        }
        
        if(!allowed) throw new IllegalArgumentException("Select does not support binding pattern '" + bindingPattern + "'");

		Pair<String, String>[] fields = getFields();

		assert(bindingPattern.length() == fields.length);
		int constantIndex = 0;
		for(int i=0;i<bindingPattern.length();++i) {
			Class<?> clazz = getClass(fields[i].second);
			switch(bindingPattern.charAt(i)) {
			case 'b':
				if(!clazz.isInstance(constants[constantIndex++])) throw new IllegalArgumentException("Invalid constant.");
				break;
			case 'f':
				break;
			default:
				throw new IllegalArgumentException("Invalid binding character '" + bindingPattern.charAt(i) + "'");
			}
		}

	}

}
