/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.GenericRelation;

/**
 * TODO: how to use
 * 
 * TODO: make a statement about synchronization requirements imposed by the interface
 * 
 * TODO: what exceptions are the methods supposed to throw? any checked exceptions?
 * 
 * @author Antti Villberg
 */
public interface IndexedRelations {

    /**
     * @param monitor
     * @param search
     * @param session
     * @param relation
     * @param input
     * @param maxResultCount
     * @return
     * @throws IndexException
     */
    public List<Map<String, Object>> query(IProgressMonitor monitor, String search, RequestProcessor session,
            Resource relation, Resource input, int maxResultCount) throws IndexException;

    public List<Resource> queryResources(IProgressMonitor monitor, String search, RequestProcessor session,
            Resource relation, Resource input, int maxResultCount) throws IndexException;

    /**
     * @param monitor
     * @param processor
     * @param relation
     * @param resource
     * @param input
     * @param documents
     * @throws IndexException
     */
    public void insert(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation,
            Resource resource, Resource input, Collection<Object[]> documents)
    throws IndexException;

    /**
     * @param monitor
     * @param processor
     * @param relation
     * @param resource
     * @param input
     * @param key
     * @param keyValues
     * @throws IndexException
     */
    public void remove(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation,
            Resource resource, Resource input, String key, Collection<Object> keyValues)
    throws IndexException;

    public void removeAll(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation,
            Resource resource, Resource input)
    throws IndexException;
    
    /**
     * @param monitor
     * @param processor
     * @param relation
     * @param resource
     * @param input
     * @param key
     * @param keyValues
     * @param documents
     * @throws IndexException
     */
    public boolean replace(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation,
            Resource resource, Resource input, String key, Collection<Object> keyValues, Collection<Object[]> documents)
    throws IndexException;

    public void reset(IProgressMonitor monitor, RequestProcessor processor, Resource resource, Resource input)
    throws IndexException;

}
