/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.children;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * A child rule is a part of child contribution that tells how the child nodes are found.
 * @author Hannu Niemistö
 */
public interface ChildRule {
    /**
     * Checks if the child rule is compatible with the content type.
     * Because this check is made when contribution is created, 
     * the type of the parent content is not checked anymore in getChildren.
     */
    boolean isCompatible(Class<?> contentType);
    
    /**
     * Given parent content produces child contents.
     */
    Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException;
    
    /**
     * Given child content produces possible parent contents.
     */
    Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException;
}
