/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.audit.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.simantics.audit.Activator;
import org.simantics.audit.AuditLoggingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLoggingAPIClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLoggingAPIClient.class);
    private Client httpClient;
    private WebTarget base;
    private String uuid;

    public AuditLoggingAPIClient(String id, String serverAddress) throws AuditLoggingException {
        ClientConfig configuration = new ClientConfig();
        configuration.register(JacksonFeature.class);
        this.httpClient = ClientBuilder.newClient((Configuration)configuration);
        if (!serverAddress.startsWith("http://") && !serverAddress.startsWith("https://")) {
            serverAddress = "http://" + serverAddress;
        }
        this.base = this.httpClient.target(serverAddress);
        this.uuid = AuditLoggingAPIClient.possibleUUIDFromFile();
        if (this.uuid == null) {
            this.register(id);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    private void register(String id) throws AuditLoggingException {
        try {
            Response response = this.base.path("register").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(Collections.singletonMap("id", id)));
            Map payload = (Map)response.readEntity(Map.class);
            String possibleUUID = (String)payload.get("uuid");
            if (possibleUUID != null && !possibleUUID.isEmpty()) {
                this.persistUUID(possibleUUID);
            } else {
                LOGGER.warn("Invalid response received from {} for register with response payload {}", (Object)this.base.getUri(), (Object)payload);
            }
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }

    private static Path auditLoggingFile() {
        return Activator.getLogLocation().resolve(".auditlogging");
    }

    private static String possibleUUIDFromFile() {
        Path auditLoggingFile = AuditLoggingAPIClient.auditLoggingFile();
        if (Files.exists(auditLoggingFile, new LinkOption[0])) {
            try {
                String possibleUUID = new String(Files.readAllBytes(auditLoggingFile));
                if (possibleUUID != null && !possibleUUID.isEmpty()) {
                    return possibleUUID;
                }
                LOGGER.warn(".auditlogging file exists but is somehow corrupted");
            }
            catch (IOException e) {
                LOGGER.error("Could not read .auditlogging file and related information", (Throwable)e);
            }
        }
        return null;
    }

    private void persistUUID(String possibleUUID) throws IOException {
        Path auditLoggingFile = AuditLoggingAPIClient.auditLoggingFile();
        Files.write(auditLoggingFile, possibleUUID.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.uuid = possibleUUID;
    }

    public void log(Map<String, Object> message) throws AuditLoggingException {
        try {
            this.base.path(this.uuid).path("log").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(message));
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }

    public void error(Map<String, Object> message) throws AuditLoggingException {
        try {
            this.base.path(this.uuid).path("error").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(message));
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }

    public void trace(Map<String, Object> message) throws AuditLoggingException {
        try {
            this.base.path(this.uuid).path("trace").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(message));
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }
}

