/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.maps.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.simantics.district.maps.server.NodeJS;
import org.simantics.district.maps.server.prefs.MapsServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;

public class TileserverMapnik {
    private static final Logger LOGGER = LoggerFactory.getLogger(TileserverMapnik.class);
    private static final String[] ADDITIONAL_DEPENDENCIES = new String[]{"tilelive-vector@3.9.4", "tilelive-tmstyle@0.6.0"};
    private SystemProcess process;
    private Path serverRoot;
    private AtomicBoolean running = new AtomicBoolean(false);

    TileserverMapnik(Path serverRoot) {
        this.serverRoot = serverRoot.normalize();
    }

    public boolean isRunning() throws IOException, InterruptedException {
        return this.process == null ? false : this.process.isAlive() && this.isReady();
    }

    public boolean isReady() {
        return this.running.get();
    }

    public void start() throws Exception {
        if (Files.exists(this.getPid(), new LinkOption[0])) {
            String pid = new String(Files.readAllBytes(this.getPid()));
            PidProcess pr = Processes.newPidProcess((int)Integer.parseInt(pid));
            pr.destroyForcefully();
        }
        if (this.checkAndInstall(null)) {
            this.checkAndInstall(ADDITIONAL_DEPENDENCIES[0]);
            this.checkAndInstall(ADDITIONAL_DEPENDENCIES[1]);
        }
        this.checkConfigJson();
        this.checkTm2Styles();
        if (this.process != null && this.process.isAlive()) {
            return;
        }
        StartedProcess startedProcess = new ProcessExecutor().directory(this.serverRoot.resolve("tileserver-mapnik").toFile()).destroyOnExit().environment(this.getEnv()).command(new String[]{NodeJS.executable().toString(), this.getTessera().toString(), "-c", this.getConfigJson().toString(), "-p", Integer.toString(MapsServerPreferences.defaultPort())}).redirectOutput((OutputStream)Slf4jStream.ofCaller().asDebug()).start();
        Process nativeProcess = startedProcess.getProcess();
        this.process = Processes.newStandardProcess((Process)nativeProcess);
        int pid = PidUtil.getPid((Process)nativeProcess);
        Files.write(this.getPid(), String.valueOf(pid).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.running.set(true);
    }

    private Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("MAPNIK_FONT_PATH", this.getFonts().toString());
        env.put("ICU_DATA", this.getICU().toString());
        return env;
    }

    public void stop() throws IOException, InterruptedException {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcefully();
            if (!this.process.waitFor(2000L, TimeUnit.MILLISECONDS)) {
                this.process.destroyForcefully();
                if (this.process.isAlive()) {
                    LOGGER.error("Could not shutdown TileserverMapnik!");
                }
            }
            this.process = null;
            Files.delete(this.getPid());
            this.running.set(false);
        }
    }

    private Path getPid() {
        return this.serverRoot.resolve("pid");
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    private boolean checkIfInstalled(String module) throws Exception {
        int retVal;
        String tileserverMapnik = this.tileserverMapnikRoot().toString();
        Throwable throwable = null;
        Object var5_5 = null;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            retVal = module == null ? NodeJS.npm(output, "--prefix", tileserverMapnik, "list") : NodeJS.npm(output, "--prefix", tileserverMapnik, "list", module);
            new String(output.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return retVal == 0;
    }

    private boolean install(String module) throws Exception {
        String tileserverMapnik = this.tileserverMapnikRoot().toString();
        int retVal = module == null ? NodeJS.npm(null, "--prefix", tileserverMapnik, "install", "--save") : NodeJS.npm(null, "--prefix", tileserverMapnik, "install", module, "--save");
        if (retVal != 0) {
            LOGGER.warn("Could not install module " + module == null ? "package.json" : String.valueOf(module) + "! " + retVal);
        }
        return retVal == 0;
    }

    private boolean checkAndInstall(String module) throws Exception {
        boolean installed = this.checkIfInstalled(module);
        if (!installed) {
            this.install(module);
        }
        return !installed;
    }

    private Path tileserverMapnikRoot() {
        return this.serverRoot.resolve("tileserver-mapnik").toAbsolutePath();
    }

    private Path getFonts() {
        return this.serverRoot.resolve("fonts").toAbsolutePath();
    }

    private Path getICU() {
        return this.serverRoot.resolve("tileserver-mapnik/node_modules/tilelive-vector/node_modules/mapnik/lib/binding/node-v46-win32-x64/share/icu").toAbsolutePath();
    }

    private Path getTessera() {
        return this.serverRoot.resolve("tileserver-mapnik/bin/tessera.js").toAbsolutePath();
    }

    private Path getConfigJson() {
        return this.serverRoot.resolve("config.json").toAbsolutePath();
    }

    public List<String> availableMBTiles() throws IOException {
        Path data = this.getDataDirectory();
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> paths = Files.walk(data, new FileVisitOption[0]);){
            paths.forEach(p -> {
                if (!p.equals(data)) {
                    String tiles = p.getFileName().toString();
                    result.add(tiles);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private void checkConfigJson() throws JsonParseException, JsonMappingException, IOException {
        Path configJson = this.getConfigJson();
        HashMap config = new HashMap();
        Path tm2 = this.getStyleDirectory();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
            stream.forEach(p -> {
                Path projectYaml = p.resolve("project.yml");
                if (Files.exists(projectYaml, new LinkOption[0])) {
                    HashMap<String, String> source = new HashMap<String, String>();
                    Path tm2style = this.serverRoot.relativize(projectYaml.getParent());
                    String prefix = "tmstyle://../";
                    String tmStyle = String.valueOf(prefix) + tm2style.toString();
                    source.put("source", tmStyle);
                    config.put("/" + projectYaml.getParent().getFileName().toString(), source);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue(Files.newOutputStream(configJson, StandardOpenOption.TRUNCATE_EXISTING), config);
    }

    public Path getStyleDirectory() {
        return this.serverRoot.resolve("tm2");
    }

    public Path getDataDirectory() {
        return this.serverRoot.resolve("data");
    }

    public Path getCurrentTiles() {
        return this.getDataDirectory().resolve(MapsServerPreferences.currentMBTiles());
    }

    public void checkTm2Styles() {
        Path tm2 = this.getStyleDirectory();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
                stream.forEach(p -> {
                    Path projectYaml = p.resolve("project.yml");
                    Yaml yaml = new Yaml();
                    Map data = null;
                    try {
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (InputStream input = Files.newInputStream(projectYaml, StandardOpenOption.READ);){
                            data = (Map)yaml.loadAs(input, Map.class);
                            Path tiles = this.serverRoot.relativize(this.getCurrentTiles());
                            String tmStyle = "mbtiles://../" + tiles.toString();
                            data.put("source", tmStyle);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not read yaml", (Throwable)e);
                    }
                    try {
                        Files.write(projectYaml, yaml.dump(data).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not write yaml", (Throwable)e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not browse tm2 styles", (Throwable)e);
        }
    }

    public List<String> listStyles() throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        Path tm2 = this.getStyleDirectory();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
            stream.forEach(p -> results.add(p.getFileName().toString()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }
}

