/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.geotools.referencing.CRS;
import org.simantics.district.imports.ui.CSVImportModel;
import org.simantics.district.imports.ui.controls.DynamicComboFieldEditor;

public class CSVImportWizardPage
extends WizardPage {
    private CSVImportModel model;
    private Map<Integer, String> headerIndexAndValues = new HashMap<Integer, String>();
    private Table headerTable;
    private Combo delimiterCombo;
    private TableColumnLayout tableColumnLayout;
    private Composite tableComposite;
    private DynamicComboFieldEditor componentMappingSelector;
    private DynamicComboFieldEditor labelSelector;
    private DynamicComboFieldEditor xCoordSelector;
    private DynamicComboFieldEditor yCoordSelector;
    private DynamicComboFieldEditor zValueSelector;
    private DynamicComboFieldEditor startXCoordSelector;
    private DynamicComboFieldEditor startYCoordSelector;
    private DynamicComboFieldEditor startZValueSelector;
    private DynamicComboFieldEditor endXCoordSelector;
    private DynamicComboFieldEditor endYCoordSelector;
    private DynamicComboFieldEditor endZValueSelector;
    private DynamicComboFieldEditor tempValueSelector;
    private DynamicComboFieldEditor pressureValueSelector;
    private DynamicComboFieldEditor outerDiameterSelector;
    private DynamicComboFieldEditor diameterSelector;
    private DynamicComboFieldEditor nominalMassFlowSelector;
    private Group indexMappingGroup;
    private Composite composite;
    private Button isVertexImport;
    private Combo sourceCRSCombo;

    protected CSVImportWizardPage(CSVImportModel model) {
        super("Import CSV Data");
        this.model = model;
        this.setMessage("Select column index mappings");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.composite);
        Label label = new Label(this.composite, 0);
        label.setText("Select delimiter");
        this.delimiterCombo = new Combo(this.composite, 12);
        this.delimiterCombo.setToolTipText("Select the delimiter that is used to separate elements in the CSV file");
        this.delimiterCombo.setItems(this.model.getDelimiterFormats());
        this.delimiterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDelimiterByLabel(CSVImportWizardPage.this.delimiterCombo.getItem(CSVImportWizardPage.this.delimiterCombo.getSelectionIndex()));
                CSVImportWizardPage.this.updateHeaders();
                CSVImportWizardPage.this.updateCombos();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableComposite = new Composite(this.composite, 2048);
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        label = new Label(this.composite, 0);
        label.setText("Select source Coordinate Reference System");
        this.sourceCRSCombo = new Combo(this.composite, 0);
        this.sourceCRSCombo.setToolTipText("Select the coordinate reference system that is used in the source material for possible transformation to target coordinate reference system (EPSG:4326)");
        Set codes = CRS.getSupportedCodes((String)"EPSG");
        this.sourceCRSCombo.setItems(codes.toArray(new String[codes.size()]));
        this.sourceCRSCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String current = CSVImportWizardPage.this.sourceCRSCombo.getItem(CSVImportWizardPage.this.sourceCRSCombo.getSelectionIndex());
                CSVImportWizardPage.this.model.setSourceCRS("EPSG:" + current);
            }
        });
        this.isVertexImport = new Button(this.composite, 32);
        this.isVertexImport.setText("File contains vertices");
        this.isVertexImport.setToolTipText("Enable this if the file contains vertices, i.e. points");
        this.isVertexImport.setSelection(this.model.isVertexImport());
        this.isVertexImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setVertexImport(CSVImportWizardPage.this.isVertexImport.getSelection());
                CSVImportWizardPage.this.updateControls(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateControls(true);
        this.updateHeaders();
        this.setControl((Control)this.composite);
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (CSVImportWizardPage.this.isCurrentPage()) {
                        CSVImportWizardPage.this.updateControls(false);
                    }
                }
            });
        }
        this.validatePageComplete();
    }

    private void updateControls(boolean initial) {
        this.createIndexMappingGroup();
        this.updateCombos();
        if (!initial) {
            this.composite.layout(true, true);
        }
    }

    private void createIndexMappingGroup() {
        if (this.indexMappingGroup != null) {
            this.indexMappingGroup.dispose();
        }
        this.indexMappingGroup = new Group(this.composite, 0);
        this.indexMappingGroup.setText("Column index mapping");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.indexMappingGroup);
        if (this.model.isVertexImport()) {
            this.createVertexIndexMappingField(this.indexMappingGroup);
        } else {
            this.createEdgeIndexMappingField(this.indexMappingGroup);
        }
        this.createCommonIndexMappingField(this.indexMappingGroup);
    }

    private void createCommonIndexMappingField(Group parent) {
        this.componentMappingSelector = new DynamicComboFieldEditor("componentMapping", "Apros component mapping", (Composite)parent);
        this.componentMappingSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setComponentMappingIndex(Integer.parseInt(CSVImportWizardPage.this.componentMappingSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void createVertexIndexMappingField(Group parent) {
        this.xCoordSelector = new DynamicComboFieldEditor("xCoord", "X Coordinate", (Composite)parent);
        this.xCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.xCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.yCoordSelector = new DynamicComboFieldEditor("yCoord", "Y Coordinate", (Composite)parent);
        this.yCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.yCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.zValueSelector = new DynamicComboFieldEditor("zValue", "Z Value", (Composite)parent);
        this.zValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.zValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.tempValueSelector = new DynamicComboFieldEditor("tempValue", "Temperature value", (Composite)parent);
        this.tempValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setTempIndex(Integer.parseInt(CSVImportWizardPage.this.tempValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.pressureValueSelector = new DynamicComboFieldEditor("pressureValue", "Pressure value", (Composite)parent);
        this.pressureValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setPressureIndex(Integer.parseInt(CSVImportWizardPage.this.pressureValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void createEdgeIndexMappingField(Group parent) {
        this.startXCoordSelector = new DynamicComboFieldEditor("startxCoord", "Start X Coordinate", (Composite)parent);
        this.startXCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startXCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.startYCoordSelector = new DynamicComboFieldEditor("startyCoord", "Start Y Coordinate", (Composite)parent);
        this.startYCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startYCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.startZValueSelector = new DynamicComboFieldEditor("startzValue", "Start Z Value", (Composite)parent);
        this.startZValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startZValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endXCoordSelector = new DynamicComboFieldEditor("endxCoord", "End X Coordinate", (Composite)parent);
        this.endXCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endXCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endYCoordSelector = new DynamicComboFieldEditor("endyCoord", "End Y Coordinate", (Composite)parent);
        this.endYCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endYCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endZValueSelector = new DynamicComboFieldEditor("endzValue", "End Z Value", (Composite)parent);
        this.endZValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endZValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.diameterSelector = new DynamicComboFieldEditor("diameterValue", "Diameter value", (Composite)parent);
        this.diameterSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDiameterIndex(Integer.parseInt(CSVImportWizardPage.this.diameterSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.outerDiameterSelector = new DynamicComboFieldEditor("outerDiameterValue", "Outer Diameter value", (Composite)parent);
        this.outerDiameterSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setOuterDiameterIndex(Integer.parseInt(CSVImportWizardPage.this.outerDiameterSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalMassFlowSelector = new DynamicComboFieldEditor("nominalMassFlowValue", "Nominal Mass Flow", (Composite)parent);
        this.nominalMassFlowSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalMassFlowIndex(Integer.parseInt(CSVImportWizardPage.this.nominalMassFlowSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void updateCombos() {
        String[][] namesAndValues = new String[this.headerIndexAndValues.size()][];
        int i = 0;
        for (Map.Entry<Integer, String> entry : this.headerIndexAndValues.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            String[] nameAndValue = new String[]{value, Integer.toString(key)};
            namesAndValues[i++] = nameAndValue;
        }
        if (this.model.isVertexImport()) {
            this.updateVertexCombos(namesAndValues);
        } else {
            this.updateEdgeCombos(namesAndValues);
        }
        this.componentMappingSelector.updateCombo(namesAndValues);
    }

    private void updateEdgeCombos(String[][] namesAndValues) {
        this.startXCoordSelector.updateCombo(namesAndValues);
        this.endXCoordSelector.updateCombo(namesAndValues);
        this.startYCoordSelector.updateCombo(namesAndValues);
        this.endYCoordSelector.updateCombo(namesAndValues);
        this.startZValueSelector.updateCombo(namesAndValues);
        this.endZValueSelector.updateCombo(namesAndValues);
        this.diameterSelector.updateCombo(namesAndValues);
        this.outerDiameterSelector.updateCombo(namesAndValues);
        this.nominalMassFlowSelector.updateCombo(namesAndValues);
    }

    private void updateVertexCombos(String[][] namesAndValues) {
        this.xCoordSelector.updateCombo(namesAndValues);
        this.yCoordSelector.updateCombo(namesAndValues);
        this.zValueSelector.updateCombo(namesAndValues);
        this.pressureValueSelector.updateCombo(namesAndValues);
        this.tempValueSelector.updateCombo(namesAndValues);
    }

    private void updateHeaders() {
        if (this.headerTable != null) {
            this.headerTable.dispose();
        }
        this.headerTable = new Table(this.tableComposite, 0);
        this.headerTable.setHeaderVisible(true);
        this.headerTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.tableComposite);
        int i = 0;
        while (i < this.headerTable.getColumns().length) {
            TableColumn column = this.headerTable.getColumns()[i];
            column.dispose();
            ++i;
        }
        i = 0;
        while (i < this.headerTable.getItemCount()) {
            TableItem item = this.headerTable.getItem(i);
            item.dispose();
            ++i;
        }
        this.headerIndexAndValues.clear();
        try {
            List<CSVRecord> rows = this.model.getRows(5);
            int k = 0;
            while (k < rows.size()) {
                CSVRecord row = rows.get(k);
                int columnCount = row.size();
                int i2 = 0;
                while (i2 < columnCount) {
                    String value = row.get(i2);
                    if (k == 0) {
                        TableColumn headerCol = new TableColumn(this.headerTable, 0);
                        headerCol.setText(value);
                        this.tableColumnLayout.setColumnData((Widget)headerCol, (ColumnLayoutData)new ColumnWeightData(10));
                        headerCol.pack();
                        this.headerIndexAndValues.put(i2, value);
                    } else {
                        int actualK = k - 1;
                        int itemCount = this.headerTable.getItemCount();
                        TableItem item = actualK >= itemCount ? new TableItem(this.headerTable, 0) : this.headerTable.getItem(actualK);
                        item.setText(i2, value);
                    }
                    ++i2;
                }
                ++k;
            }
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected void validatePageComplete() {
        if (this.model.isVertexImport()) {
            this.setPageComplete(this.model.getXCoordIndex() != -1 && this.model.getYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        } else {
            this.setPageComplete(this.model.getStartXCoordIndex() != 1 && this.model.getStartYCoordIndex() != -1 && this.model.getEndXCoordIndex() != -1 && this.model.getEndYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        }
    }
}

