/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.district.imports.ui.CSVImportModel;
import org.simantics.district.network.ui.function.Functions;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileSelectionListener;
import org.simantics.utils.ui.widgets.FileSelectionWidget;

public class CSVImportWizardFirstPage
extends WizardPage
implements FileSelectionListener {
    private final CSVImportModel model;
    private Map<String, Resource> diagrams = new HashMap<String, Resource>();
    private Combo diagramCombo;
    private FileSelectionWidget csvSelection;

    public CSVImportWizardFirstPage(CSVImportModel model) {
        super("Select source for CSV data");
        this.model = model;
        this.setMessage("Select target network diagram and source for CSV-data");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        Group parentConfigurationGroup = new Group(composite, 0);
        parentConfigurationGroup.setText("Select target network diagram");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)parentConfigurationGroup);
        this.diagramCombo = new Combo((Composite)parentConfigurationGroup, 12);
        this.diagramCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String selection = CSVImportWizardFirstPage.this.diagramCombo.getItem(CSVImportWizardFirstPage.this.diagramCombo.getSelectionIndex());
                CSVImportWizardFirstPage.this.model.setParentDiagram((Resource)CSVImportWizardFirstPage.this.diagrams.get(selection));
                CSVImportWizardFirstPage.this.validateComplete();
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)parentConfigurationGroup);
        this.csvSelection = new FileSelectionWidget(composite, "CSV file", 4096);
        this.csvSelection.addListener((FileSelectionListener)this);
        this.updateAvailableParents();
        this.validateComplete();
        this.setControl((Control)composite);
    }

    private void updateAvailableParents() {
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Collection diagrams = Functions.getDistrictDiagrams((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    Resource projectResource = Simantics.getProjectResource();
                    String projectURI = graph.getURI(projectResource);
                    for (Resource diagram : diagrams) {
                        Resource composite = graph.getSingleObject(diagram, MOD.DiagramToComposite);
                        String compositeURI = graph.getURI(composite);
                        String path = compositeURI.replace(projectURI, "");
                        CSVImportWizardFirstPage.this.diagrams.put(path, diagram);
                    }
                }
            });
            this.diagramCombo.setItems(this.diagrams.keySet().toArray(new String[this.diagrams.size()]));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void fileSelected(FileOrDirectorySelectionWidget source, String[] filename) {
        String[] selection = this.csvSelection.getFilename();
        if (selection != null && selection.length > 0) {
            Path csvFile = Paths.get(selection[0], new String[0]);
            if (!Files.exists(csvFile, new LinkOption[0])) {
                this.setErrorMessage("File " + csvFile.toAbsolutePath() + " does not exist");
            } else {
                this.model.setSource(csvFile);
                this.validateComplete();
            }
        }
    }

    private void validateComplete() {
        this.setPageComplete(this.model.getSource() != null && this.model.getParentDiagram() != null);
    }
}

