/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.imports.ui.CSVImportModel;
import org.simantics.district.imports.ui.CSVImportWizardFirstPage;
import org.simantics.district.imports.ui.CSVImportWizardPage;
import org.simantics.district.imports.ui.ComponentMappingPage;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DNEdgeBuilder;
import org.simantics.maps.MapScalingTransform;
import org.simantics.utils.ui.ExceptionUtils;

public class CSVImportWizard
extends Wizard
implements IImportWizard {
    private CSVImportModel model;

    public CSVImportWizard() {
        this.setWindowTitle("Import CSV data");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.model = new CSVImportModel();
        this.addPage((IWizardPage)new CSVImportWizardFirstPage(this.model));
        this.addPage((IWizardPage)new CSVImportWizardPage(this.model));
        this.addPage((IWizardPage)new ComponentMappingPage(this.model));
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Path csvFile = CSVImportWizard.this.model.getSource();
                        char delim = CSVImportWizard.this.model.getDelimiter();
                        final List rows = DistrictImportUtils.readRows((Path)csvFile, (char)delim, (int)-1);
                        final int xCoordColumnIndex = CSVImportWizard.this.model.getXCoordIndex();
                        final int yCoordColumnIndex = CSVImportWizard.this.model.getYCoordIndex();
                        final int zCoordColumnIndex = CSVImportWizard.this.model.getZCoordIndex();
                        final int tempColumnIndex = CSVImportWizard.this.model.getTempIndex();
                        final int pressureColumnIndex = CSVImportWizard.this.model.getPressureIndex();
                        final int startXCoordColumnIndex = CSVImportWizard.this.model.getStartXCoordIndex();
                        final int startYCoordColumnIndex = CSVImportWizard.this.model.getStartYCoordIndex();
                        CSVImportWizard.this.model.getStartZCoordIndex();
                        final int endXCoordColumnIndex = CSVImportWizard.this.model.getEndXCoordIndex();
                        final int endYCoordColumnIndex = CSVImportWizard.this.model.getEndYCoordIndex();
                        CSVImportWizard.this.model.getEndZCoordIndex();
                        final int diameterColumnIndex = CSVImportWizard.this.model.getDiameterIndex();
                        final int outerDiameterColumnIndex = CSVImportWizard.this.model.getOuterDiamterIndex();
                        final int nominalMassFlowIndex = CSVImportWizard.this.model.getNominalMassFlowIndex();
                        final int mappingColumn = CSVImportWizard.this.model.getComponentMappingIndex();
                        String sourceEPSGCRS = CSVImportWizard.this.model.getSourceCRS();
                        MathTransform transform = null;
                        boolean doTransform = false;
                        if (sourceEPSGCRS != null && !sourceEPSGCRS.isEmpty()) {
                            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEPSGCRS);
                            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
                            doTransform = true;
                        }
                        final boolean actualDoTransform = doTransform;
                        final MathTransform actualTransform = transform;
                        Simantics.getSession().syncRequest(new Write(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                                int k = 1;
                                while (k < rows.size()) {
                                    block24: {
                                        CSVRecord row = (CSVRecord)rows.get(k);
                                        String mappingValue = row.get(mappingColumn);
                                        try {
                                            String nominalMassFlowS;
                                            String outerDiameterS;
                                            double[] endCoords;
                                            double[] startCoords;
                                            if (CSVImportWizard.this.model.isVertexImport()) {
                                                String pressureS;
                                                double[] coords;
                                                String xCoords = row.get(xCoordColumnIndex);
                                                String yCoords = row.get(yCoordColumnIndex);
                                                double xCoord = Double.parseDouble(xCoords);
                                                double yCoord = Double.parseDouble(yCoords);
                                                String zs = row.get(zCoordColumnIndex);
                                                double z = 0.0;
                                                if (!zs.isEmpty()) {
                                                    try {
                                                        z = Double.parseDouble(zs);
                                                    }
                                                    catch (NumberFormatException e) {
                                                        throw new DatabaseException((Throwable)e);
                                                    }
                                                }
                                                if (actualDoTransform) {
                                                    DirectPosition2D targetPos = new DirectPosition2D();
                                                    DirectPosition2D sourcePos = new DirectPosition2D(xCoord, yCoord);
                                                    DirectPosition res = actualTransform.transform((DirectPosition)sourcePos, (DirectPosition)targetPos);
                                                    coords = res.getCoordinate();
                                                } else {
                                                    coords = new double[]{xCoord / MapScalingTransform.getScaleX(), yCoord / MapScalingTransform.getScaleY()};
                                                }
                                                Resource vertex = DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)CSVImportWizard.this.model.getParentDiagram(), (double[])new double[]{coords[1], -coords[0]}, (Resource)CSVImportWizard.this.model.getComponentMappings().get(mappingValue));
                                                graph.claimLiteral(vertex, DN.Vertex_HasElevation, (Object)z, (Binding)Bindings.DOUBLE);
                                                String tempS = row.get(tempColumnIndex);
                                                if (!tempS.isEmpty()) {
                                                    try {
                                                        double temp = Double.parseDouble(tempS);
                                                        graph.claimLiteral(vertex, DN.Vertex_HasTemperature, (Object)temp, (Binding)Bindings.DOUBLE);
                                                    }
                                                    catch (NumberFormatException e) {
                                                        throw new DatabaseException((Throwable)e);
                                                    }
                                                }
                                                if ((pressureS = row.get(pressureColumnIndex)).isEmpty()) break block24;
                                                try {
                                                    double pressure = Double.parseDouble(pressureS);
                                                    graph.claimLiteral(vertex, DN.Vertex_HasPressure, (Object)pressure, (Binding)Bindings.DOUBLE);
                                                    break block24;
                                                }
                                                catch (NumberFormatException e) {
                                                    throw new DatabaseException((Throwable)e);
                                                }
                                            }
                                            String startXCoords = row.get(startXCoordColumnIndex);
                                            String startYCoords = row.get(startYCoordColumnIndex);
                                            String endXCoords = row.get(endXCoordColumnIndex);
                                            String endYCoords = row.get(endYCoordColumnIndex);
                                            double startXCoord = Double.parseDouble(startXCoords);
                                            double startYCoord = Double.parseDouble(startYCoords);
                                            double endXCoord = Double.parseDouble(endXCoords);
                                            double endYCoord = Double.parseDouble(endYCoords);
                                            if (actualDoTransform) {
                                                DirectPosition2D startTargetPos = new DirectPosition2D();
                                                DirectPosition2D startSourcePos = new DirectPosition2D(startXCoord, startYCoord);
                                                DirectPosition startRes = actualTransform.transform((DirectPosition)startSourcePos, (DirectPosition)startTargetPos);
                                                startCoords = startRes.getCoordinate();
                                                DirectPosition2D endTargetPos = new DirectPosition2D();
                                                DirectPosition2D endSourcePos = new DirectPosition2D(endXCoord, endYCoord);
                                                DirectPosition endRes = actualTransform.transform((DirectPosition)endSourcePos, (DirectPosition)endTargetPos);
                                                endCoords = endRes.getCoordinate();
                                            } else {
                                                startCoords = new double[]{startXCoord / MapScalingTransform.getScaleX(), startYCoord / MapScalingTransform.getScaleY()};
                                                endCoords = new double[]{endXCoord / MapScalingTransform.getScaleX(), endYCoord / MapScalingTransform.getScaleY()};
                                            }
                                            Resource edge = DNEdgeBuilder.create((WriteGraph)graph, (Resource)CSVImportWizard.this.model.getParentDiagram(), (double[])new double[]{startCoords[1], -startCoords[0]}, (double[])new double[]{endCoords[1], -endCoords[0]}, (double)1.0E-7);
                                            graph.claim(edge, DistrictNetworkResource.getInstance((ReadGraph)graph).HasMapping, CSVImportWizard.this.model.getComponentMappings().get(mappingValue));
                                            String diameterS = row.get(diameterColumnIndex);
                                            if (!diameterS.isEmpty()) {
                                                try {
                                                    double diameter = Double.parseDouble(diameterS);
                                                    graph.claimLiteral(edge, DN.Edge_HasDiameter, (Object)diameter);
                                                }
                                                catch (NumberFormatException e) {
                                                    throw new DatabaseException((Throwable)e);
                                                }
                                            }
                                            if (!(outerDiameterS = row.get(outerDiameterColumnIndex)).isEmpty()) {
                                                try {
                                                    double outerDiameter = Double.parseDouble(outerDiameterS);
                                                    graph.claimLiteral(edge, DN.Edge_HasOuterDiameter, (Object)outerDiameter);
                                                }
                                                catch (NumberFormatException e) {
                                                    throw new DatabaseException((Throwable)e);
                                                }
                                            }
                                            if ((nominalMassFlowS = row.get(nominalMassFlowIndex)).isEmpty()) break block24;
                                            try {
                                                double nominalMassFlow = Double.parseDouble(nominalMassFlowS);
                                                graph.claimLiteral(edge, DN.Edge_HasNominalMassFlow, (Object)nominalMassFlow);
                                            }
                                            catch (NumberFormatException e) {
                                                throw new DatabaseException((Throwable)e);
                                            }
                                        }
                                        catch (MismatchedDimensionException | TransformException | DatabaseException e) {
                                            throw new DatabaseException(e);
                                        }
                                    }
                                    ++k;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage(t.getMessage());
            ExceptionUtils.logAndShowError((Throwable)t);
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
    }
}

