/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.simantics.db.Resource;
import org.simantics.district.imports.DistrictImportUtils;

public class CSVImportModel {
    private Resource targetDiagram;
    private Path source;
    private char delimiter;
    private boolean readFirstAsHeader = true;
    private Map<String, Character> delimiters;
    private int xCoordIndex = -1;
    private int yCoordIndex = -1;
    private int zCoordIndex = -1;
    private int startXCoordIndex = -1;
    private int startYCoordIndex = -1;
    private int startZCoordIndex = -1;
    private int endXCoordIndex = -1;
    private int endYCoordIndex = -1;
    private int endZCoordIndex = -1;
    private int componentMappingIndex = -1;
    private Map<String, Resource> componentMappings = new HashMap<String, Resource>();
    private boolean isVertexImport;
    private String sourceCRS;
    private int tempIndex;
    private int pressureIndex;
    private int diameterIndex;
    private int outerDiamterIndex;
    private int nominalMassFlowIndex;

    public CSVImportModel() {
        this.delimiters = DistrictImportUtils.getSupportedCSVDelimiterFormats();
    }

    public void setSource(Path source) {
        this.source = source;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setReadFirstAsHeader(boolean read) {
        this.readFirstAsHeader = read;
    }

    public Path getSource() {
        return this.source;
    }

    public List<CSVRecord> getRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readRows((Path)this.source, (char)this.delimiter, (int)amount);
        }
        return Collections.emptyList();
    }

    public Map<DistrictImportUtils.CSVHeader, List<String>> getHeaderAndRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readCSVHeaderAndRows((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader, (int)amount);
        }
        return Collections.emptyMap();
    }

    public Map<String, Integer> getHeader() throws IOException {
        Map header = null;
        if (this.source != null) {
            header = DistrictImportUtils.readCSVHeader((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader);
        }
        if (header == null) {
            header = Collections.emptyMap();
        }
        return header;
    }

    public boolean getReadFirstAsHeader() {
        return this.readFirstAsHeader;
    }

    public String[] getDelimiterFormats() {
        return this.delimiters.keySet().toArray(new String[this.delimiters.size()]);
    }

    public void setDelimiterByLabel(String item) {
        this.setDelimiter(this.delimiters.get(item).charValue());
    }

    public List<Map<String, String>> readRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readRows((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader, (int)amount);
        }
        return Collections.emptyList();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public int getXCoordIndex() {
        return this.xCoordIndex;
    }

    public void setXCoordIndex(int xCoordIndex) {
        this.xCoordIndex = xCoordIndex;
    }

    public int getYCoordIndex() {
        return this.yCoordIndex;
    }

    public void setYCoordIndex(int yCoordIndex) {
        this.yCoordIndex = yCoordIndex;
    }

    public int getZCoordIndex() {
        return this.zCoordIndex;
    }

    public void setZCoordIndex(int zCoordIndex) {
        this.zCoordIndex = zCoordIndex;
    }

    public int getComponentMappingIndex() {
        return this.componentMappingIndex;
    }

    public void setComponentMappingIndex(int componentMappingIndex) {
        this.componentMappingIndex = componentMappingIndex;
    }

    public void setParentDiagram(Resource diagram) {
        this.targetDiagram = diagram;
    }

    public Resource getParentDiagram() {
        return this.targetDiagram;
    }

    public void setComponentMappings(String value, Resource resource) {
        this.componentMappings.put(value, resource);
    }

    public Map<String, Resource> getComponentMappings() {
        return this.componentMappings;
    }

    public boolean isVertexImport() {
        return this.isVertexImport;
    }

    public void setVertexImport(boolean isVertexImport) {
        this.isVertexImport = isVertexImport;
    }

    public void setStartXCoordIndex(int parseInt) {
        this.startXCoordIndex = parseInt;
    }

    public int getStartXCoordIndex() {
        return this.startXCoordIndex;
    }

    public void setStartYCoordIndex(int parseInt) {
        this.startYCoordIndex = parseInt;
    }

    public int getStartYCoordIndex() {
        return this.startYCoordIndex;
    }

    public void setStartZCoordIndex(int parseInt) {
        this.startZCoordIndex = parseInt;
    }

    public int getStartZCoordIndex() {
        return this.startZCoordIndex;
    }

    public void setEndXCoordIndex(int parseInt) {
        this.endXCoordIndex = parseInt;
    }

    public int getEndXCoordIndex() {
        return this.endXCoordIndex;
    }

    public void setEndYCoordIndex(int parseInt) {
        this.endYCoordIndex = parseInt;
    }

    public int getEndYCoordIndex() {
        return this.endYCoordIndex;
    }

    public void setEndZCoordIndex(int parseInt) {
        this.endZCoordIndex = parseInt;
    }

    public int getEndZCoordIndex() {
        return this.endZCoordIndex;
    }

    public void setSourceCRS(String crs) {
        this.sourceCRS = crs;
    }

    public String getSourceCRS() {
        return this.sourceCRS;
    }

    public void setTempIndex(int tempIndex) {
        this.tempIndex = tempIndex;
    }

    public int getTempIndex() {
        return this.tempIndex;
    }

    public void setPressureIndex(int pressureIndex) {
        this.pressureIndex = pressureIndex;
    }

    public int getPressureIndex() {
        return this.pressureIndex;
    }

    public void setDiameterIndex(int parseInt) {
        this.diameterIndex = parseInt;
    }

    public int getDiameterIndex() {
        return this.diameterIndex;
    }

    public void setOuterDiameterIndex(int parseInt) {
        this.outerDiamterIndex = parseInt;
    }

    public int getOuterDiamterIndex() {
        return this.outerDiamterIndex;
    }

    public void setNominalMassFlowIndex(int parseInt) {
        this.nominalMassFlowIndex = parseInt;
    }

    public int getNominalMassFlowIndex() {
        return this.nominalMassFlowIndex;
    }
}

