/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ObjectVariantBinding;
import org.simantics.databoard.file.FileList;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;

public class TestVariant extends TestCase {

	VariantBinding binding;
	
	public void setUp() throws Exception {
		ObjectVariantBinding b = (ObjectVariantBinding) Bindings.OBJECT;
		
		binding = b;
	}
	
	// Test Reflection Variant (Object.class)
	public void testObject() throws Exception {
		assertTrue( binding.isInstance("Y") );
		
		Object o1 = binding.create(Bindings.getBinding(String.class), "X");
		assertTrue( binding.getContentType(o1) instanceof StringType );
		assertTrue( binding.getContentBinding(o1) instanceof StringBinding );		
		
		Object o2 = binding.create(Bindings.getBinding(Integer.class), 5);
		assertTrue( binding.getContentType(o2) instanceof IntegerType );
		assertTrue( binding.getContentBinding(o2) instanceof IntegerBinding );
				
		Object o3 = binding.create( Bindings.getBinding(int[].class), new int[] {1,2,3,4});
		assertTrue( binding.getContentType(o3) instanceof ArrayType );
		assertTrue( binding.getContentBinding(o3) instanceof ArrayBinding );

		Object o4 = binding.create( Bindings.getBinding(Rectangle2D.Double.class), new Rectangle2D.Double(0,0,100,10) );
		assertTrue( binding.getContentType(o4) instanceof RecordType );
		assertTrue( binding.getContentBinding(o4) instanceof RecordBinding );
	}
	
	// Test Binding
	// Test Binary serialization
	public void testSerialization() throws IOException, SerializerConstructionException, SerializationException, BindingConstructionException {
		File f = File.createTempFile("test", ".tmp");
		FileList<Object> list = new FileList<Object>(f, binding);
		list.add("XYZ");
		list.add(5);
		list.add(0.2342);
		list.close();		
		
		// List
		List<Object> list2 = new FileList<Object>(f, Bindings.getBinding(Object.class));
		assertEquals( new MutableString("XYZ"), list2.get(0));
		assertEquals(5, list2.get(1));
		assertEquals(0.2342, list2.get(2));
	}	
	
	// Test ascii print
	// Test ascii parse
	public void testAscii() throws IOException, BindingException, DataTypeSyntaxError, BindingConstructionException
	{
		Object o1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		Object o2 = 1234567890;
		Object o3 = new Rectangle2D.Double(50, 50, 100, 100);
		String s1 = binding.printValueDefinition(o1, true);
		String s2 = binding.printValueDefinition(o2, true);
		String s3 = binding.printValueDefinition(o3, true);
		System.out.println(s1);
		System.out.println(s2);
		System.out.println(s3);
		Object u1 = Bindings.getInstanceBinding(o1).parseValueDefinition(s1);
		Object u2 = Bindings.getInstanceBinding(o2).parseValueDefinition(s2);
		Object u3 = Bindings.getInstanceBinding(o3).parseValueDefinition(s3);
		assertEquals(o1, u1);
		assertEquals(o2, u2);
		assertEquals(o3, u3);
	}

}
