package org.simantics.databoard.example.old;
import java.io.IOException;
import java.util.Arrays;

import org.simantics.databoard.Methods;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.method.MethodInterface;

/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

public class RPCExample2 {

	public static class Server {
	
		// Server Code
		public interface NetworkProtocol {
			void elProblem();
			String execute(String command, int[] args) throws Error1;
		}

		public static class Error1 extends Exception {
			
			private static final long serialVersionUID = 1L;
			
			public String errorMessage;
			public Error1(String msg) {
				this.errorMessage = msg;
			}
			@Override
			public String toString() {
				return errorMessage;
			}
		}

	}
	
	// Client Code
	public static class Client {
		public interface NetworkProtocol {
			String execute(String cmd, int[] args) throws Error1;
		}
	
		public static class Error1 extends Exception {		
			
			private static final long serialVersionUID = 1L;
			
			public String errorMessage;
			public Error1(String errorMessage) {
				this.errorMessage = errorMessage;
			}
			@Override
			public String toString() {
				return "Error occured: "+errorMessage;
			}
		}
	}
	
	// Example Code 
	
	public static void main(String[] args) throws IOException, BindingConstructionException {

		// Server
		Server.NetworkProtocol myServer = new Server.NetworkProtocol() {
			@Override
			public String execute(String command, int[] args) throws Server.Error1 {
				if (!command.equals("start")) throw new Server.Error1("Unknown command "+command);
				return "Program started "+command+" with args "+Arrays.toString(args);
			}

			@Override
			public void elProblem() {
				// TODO Auto-generated method stub
				System.out.println("Works");
				
			}					
		};
		
		// Adapt server to MethodInterface
		MethodInterface myMI = Methods.bindInterface(Server.NetworkProtocol.class, myServer);
		
		
		// Client		
		// Adapt methodInterface to client
		Client.NetworkProtocol myMiProxy = Methods.createProxy(Client.NetworkProtocol.class, myMI);
		
		// Execute command "start"
		try {
			String result = myMiProxy.execute("start", new int[] {5,6,72,7423});
			System.out.println(result);
		} catch (Client.Error1 e) {
			System.err.println(e);
		}

		// Execute command "fault"
		try {
			String result = myMiProxy.execute("fault", new int[] {});
			System.out.println(result);
		} catch (Client.Error1 e) {
			System.err.println(e);
		}
		
	}
	
}

