/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.error.BindingConstructionException;

public class AdaptionExample2 {

	static public class CarSI {
		public String modelName;		
		public @Unit("km/h") double maxVelocity;		
		public @Unit("kg") double mass;		
		public @Unit("cm") double length; 
		public @Unit("kW") double power;
		
		@Override
		public String toString() {
			return String.format("Name:%s, Mass: %2.0f kg, Power: %2.0f kW, Speed: %2.0f km/h, Length: %2.0f cm", modelName, mass, power, maxVelocity, length);
		}
	}

	static public class CarIm {
		public String modelName;		
		public @Unit("mph") float maxVelocity;		
		public @Unit("lbs") float mass;		
		public @Unit("ft") float length; 
		public @Unit("hp(M)") float power;
		
		@Override
		public String toString() {
			return String.format("Name:%s, Mass: %2.0f lbs, Power: %2.0f hp, Speed: %2.0f mph, Length: %2.0f ft", modelName, mass, power, maxVelocity, length);
		}
	}

	public static void main(String[] args) throws AdapterConstructionException, AdaptException, BindingConstructionException {
		
		Adapter si2imAdapter = Bindings.getTypeAdapter(
				Bindings.getBinding(CarSI.class), 
				Bindings.getBinding(CarIm.class));
		
		CarSI fiatSi = new CarSI();
		fiatSi.modelName = "Fiat 500";
		fiatSi.mass = 1035.;
		fiatSi.length = 355.;
		fiatSi.maxVelocity = 205.;
		fiatSi.power = 75.;

		CarIm fiatIm = (CarIm) si2imAdapter.adapt( fiatSi );		
		
		System.out.println(fiatSi);
		System.out.println(fiatIm);
	}
	
}

