/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.type.DataTypeDefinition;
import org.simantics.databoard.type.Datatype;

public class ParserExample {

	public static void main(String[] args) throws DataTypeSyntaxError {
	    DataTypeRepository repository = new DataTypeRepository();
	    repository.addDefinitions(
	        "type Vec2 = { x : Double, y : Double } " + 
	        "type Matrix2 = { rowX : Vec2, rowY : Vec2 }"
	        );
	    Datatype type = repository.get("Matrix2");
	    Datatype type2 = repository.translate("{ matrix : Matrix2, vector : Vec2 }");
	    System.out.println(type);
	    System.out.println();
	    System.out.println(type2);
	    
	    DataTypeDefinition def = new DataTypeDefinition("Matrix2", repository.get("Matrix2"));
	    System.out.println();
	    System.out.println();
	    System.out.println(def);
	}
	
}

