/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;

public class RecursiveDeepClone {

	// Recursive classes and classes that are referenced should be annotated with
	// @Referable
	static @Referable class X {
		public X reference;
	}
	
	public static void main(String[] args) throws BindingConstructionException, BindingException {
		
		// Create recursive instance
		X original = new X();
		original.reference = original;
		
		Binding binding = Bindings.getBinding( original.getClass() );
		X copy = (X) binding.cloneUnchecked( original );

		// Print the objects
		System.out.println( "Original: "+binding.toString( original ) );
		System.out.println( "Clone   : "+binding.toString( copy     ) );
	}
	
}
