/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.SelectionProcessorExtension;
import org.simantics.selectionview.SelectionProcessorExtensionImpl;
import org.simantics.utils.strings.StringUtils;

public class SelectionProcessorExtensionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private static final String EP_NAME = "selectionProcessor";
    private ExtensionTracker tracker;
    SelectionProcessorExtension[] extensions = new SelectionProcessorExtension[0];
    private static SelectionProcessorExtensionManager INSTANCE;

    SelectionProcessorExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new SelectionProcessorExtension[0];
    }

    public SelectionProcessorExtension[] getExtensions() {
        return this.extensions;
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<SelectionProcessorExtension> newExtensions = new HashSet<SelectionProcessorExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                String id = StringUtils.safeString((String)el.getAttribute("id"));
                SelectionProcessor factory = (SelectionProcessor)el.createExecutableExtension("class");
                SelectionProcessorExtensionImpl ext = new SelectionProcessorExtensionImpl(id, factory);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                newExtensions.add(ext);
            }
            catch (CoreException e) {
                ErrorLogger.defaultLogError((String)("Failed to initialize selectionProcessor extension \"" + el.getName() + "\" with name \"" + el.getAttribute("name") + "\": " + e.getMessage()), (Throwable)e);
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new SelectionProcessorExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<SelectionProcessorExtension> newExtensions = new HashSet<SelectionProcessorExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new SelectionProcessorExtension[newExtensions.size()]);
    }

    public static synchronized SelectionProcessorExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SelectionProcessorExtensionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    public static SelectionProcessor<?, ?> getProcessor(String id) {
        SelectionProcessorExtension[] selectionProcessorExtensionArray = SelectionProcessorExtensionManager.getInstance().extensions;
        int n = SelectionProcessorExtensionManager.getInstance().extensions.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionProcessorExtension ext = selectionProcessorExtensionArray[n2];
            if (ext.getProcessor().getClass().getCanonicalName().equals(id)) {
                return ext.getProcessor();
            }
            ++n2;
        }
        return null;
    }
}

